/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.crosswire.common.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T construct(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = ClassUtil.forName(className);
        return (T)clazz.newInstance();
    }

    public static <T> T construct(String className, Object ... params) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> clazz = ClassUtil.forName(className);
        return (T)ReflectionUtil.construct(clazz, params);
    }

    public static <T> T construct(Class<T> clazz, Object ... params) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes = ReflectionUtil.describeParameters(params);
        Constructor<T> c = clazz.getConstructor(paramTypes);
        return c.newInstance(params);
    }

    public static <T> T construct(String className, Object[] params, Class<?>[] paramTypes) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] calledTypes = paramTypes;
        if (calledTypes == null) {
            calledTypes = ReflectionUtil.describeParameters(params);
        }
        Class<?> clazz = ClassUtil.forName(className);
        Constructor<?> c = clazz.getConstructor(calledTypes);
        return (T)c.newInstance(params);
    }

    public static Object invoke(Object base, String methodName, Object ... params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = base.getClass();
        return ReflectionUtil.invoke(clazz, base, methodName, params);
    }

    public static Object invoke(String call, Object ... params) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int lastDot = call.lastIndexOf(46);
        String className = call.substring(0, lastDot);
        String methodName = call.substring(lastDot + 1);
        Class<?> clazz = ClassUtil.forName(className);
        return ReflectionUtil.invoke(clazz, clazz, methodName, params);
    }

    public static <T> Object invoke(Class<T> clazz, Object obj, String methodName, Object ... params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionUtil.invoke(clazz, obj, methodName, params, null);
    }

    public static <T> Object invoke(Class<T> clazz, Object obj, String methodName, Object[] params, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?>[] calledTypes = paramTypes;
        if (calledTypes == null) {
            calledTypes = ReflectionUtil.describeParameters(params);
        }
        return ReflectionUtil.getMethod(clazz, methodName, calledTypes).invoke(obj, params);
    }

    private static Class<?>[] describeParameters(Object ... params) {
        Class[] calledTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<Object> clazz = params[i].getClass();
            if (clazz.equals(Boolean.class)) {
                clazz = Boolean.TYPE;
            }
            calledTypes[i] = clazz;
        }
        return calledTypes;
    }

    private static <T> Method getMethod(Class<T> clazz, String methodName, Class<?>[] calledTypes) throws NoSuchMethodException {
        Method[] testMethods = clazz.getMethods();
        block0: for (int i = 0; i < testMethods.length; ++i) {
            Class<?>[] testTypes;
            if (!testMethods[i].getName().equals(methodName) || (testTypes = testMethods[i].getParameterTypes()).length != calledTypes.length) continue;
            for (int j = 0; j < testTypes.length; ++j) {
                if (!testTypes[j].isAssignableFrom(calledTypes[j])) continue block0;
            }
            return testMethods[i];
        }
        throw new NoSuchMethodException(methodName);
    }
}

