/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.options;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.crosswire.common.options.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionList {
    private Map<String, Option> shortOptions;
    private Map<String, Option> longOptions = new LinkedHashMap<String, Option>();

    public OptionList() {
        this.shortOptions = new LinkedHashMap<String, Option>();
    }

    public void add(Option option) {
        char shortName = option.getShortName();
        String longName = option.getLongName();
        if (shortName != '\u0000') {
            String optionName = Character.toString(shortName);
            assert (!this.shortOptions.containsKey(optionName)) : optionName + " already present";
            this.shortOptions.put(optionName, option);
        }
        if (longName != null) {
            assert (!this.longOptions.containsKey(longName)) : longName + " already present";
            this.longOptions.put(longName, option);
        }
    }

    public List<Option> getLongOptions(String key) {
        ArrayList<Option> matches = new ArrayList<Option>();
        if (this.longOptions.containsKey(key)) {
            matches.add(this.longOptions.get(key));
        }
        for (Map.Entry<String, Option> entry : this.longOptions.entrySet()) {
            String entryKey = entry.getKey();
            Option entryValue = entry.getValue();
            if (!entryKey.startsWith(key) || matches.contains(entryValue)) continue;
            matches.add(entryValue);
        }
        return matches;
    }

    public Option getShortOption(char key) {
        String optionName = Character.toString(key);
        Option match = null;
        if (this.shortOptions.containsKey(optionName)) {
            match = this.shortOptions.get(optionName);
        }
        return match;
    }

    public List<Option> getOptions(String key) {
        Option match;
        ArrayList<Option> matches = new ArrayList<Option>();
        if (key.length() == 1 && (match = this.getShortOption(key.charAt(0))) != null) {
            matches.add(match);
        }
        for (Option match2 : this.getLongOptions(key)) {
            if (matches.contains(match2)) continue;
            matches.add(match2);
        }
        return matches;
    }
}

