/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.diff.EditType;
import org.crosswire.common.diff.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchEntry
implements Iterable<Difference> {
    private static final int MARGIN = 4;
    private static int margin = 4;
    private static Pattern newlinePattern = Pattern.compile("\n");
    private static Pattern patchPattern = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
    private List<Difference> diffs = new ArrayList<Difference>();
    private int sourceStart = 0;
    private int targetStart = 0;
    private int sourceLength = 0;
    private int targetLength = 0;

    public PatchEntry() {
    }

    public PatchEntry(String patchText) {
        this();
        this.fromText(patchText);
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public void setSourceStart(int start) {
        this.sourceStart = start;
    }

    public void adjustSourceStart(int adjustment) {
        this.sourceStart += adjustment;
    }

    public int getTargetStart() {
        return this.targetStart;
    }

    public void setTargetStart(int start) {
        this.targetStart = start;
    }

    public void adjustTargetStart(int adjustment) {
        this.targetStart += adjustment;
    }

    public int getSourceLength() {
        return this.sourceLength;
    }

    public void setSourceLength(int length) {
        this.sourceLength = length;
    }

    public void adjustSourceLength(int adjustment) {
        this.sourceLength += adjustment;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(int length) {
        this.targetLength = length;
    }

    public void adjustTargetLength(int adjustment) {
        this.targetLength += adjustment;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("@@ -");
        txt.append(this.getCoordinates(this.sourceStart, this.sourceLength));
        txt.append(" +");
        txt.append(this.getCoordinates(this.targetStart, this.targetLength));
        txt.append(" @@\n");
        for (Difference diff : this.diffs) {
            txt.append(diff.getEditType().getSymbol());
            txt.append(this.encode(diff.getText()));
            txt.append('\n');
        }
        return txt.toString();
    }

    public PatchEntry fromText(String input) {
        this.diffs.clear();
        String[] text = newlinePattern.split(input);
        char sign = '\u0000';
        String line = "";
        Matcher matcher = patchPattern.matcher(text[0]);
        matcher.matches();
        assert (matcher.groupCount() == 4) : "Invalid patch string:\n" + text[0];
        this.sourceStart = Integer.parseInt(matcher.group(1));
        if (matcher.group(2).length() == 0) {
            --this.sourceStart;
            this.sourceLength = 1;
        } else if (matcher.group(2).charAt(0) == '0') {
            this.setSourceLength(0);
        } else {
            --this.sourceStart;
            this.sourceLength = Integer.parseInt(matcher.group(2));
        }
        this.targetStart = Integer.parseInt(matcher.group(3));
        if (matcher.group(4).length() == 0) {
            --this.targetStart;
            this.targetLength = 1;
        } else if (matcher.group(4).charAt(0) == '0') {
            this.targetLength = 0;
        } else {
            --this.targetStart;
            this.targetLength = Integer.parseInt(matcher.group(4));
        }
        for (int lineCount = 1; lineCount < text.length; ++lineCount) {
            line = text[lineCount];
            if (line.length() <= 0) continue;
            sign = line.charAt(0);
            line = this.decode(line.substring(1));
            this.diffs.add(new Difference(EditType.fromSymbol(sign), line));
        }
        return this;
    }

    public String getSourceText() {
        StringBuilder txt = new StringBuilder();
        for (Difference diff : this.diffs) {
            if (EditType.INSERT.equals((Object)diff.getEditType())) continue;
            txt.append(diff.getText());
        }
        return txt.toString();
    }

    public String getTargetText() {
        StringBuilder txt = new StringBuilder();
        for (Difference diff : this.diffs) {
            if (EditType.DELETE.equals((Object)diff.getEditType())) continue;
            txt.append(diff.getText());
        }
        return txt.toString();
    }

    public void addContext(String text) {
        String suffix;
        int suffixLength;
        int maxPatternLength = new Match().maxPatternLength();
        int padding = 0;
        String pattern = text.substring(this.targetStart, this.targetStart + this.sourceLength);
        int textLength = text.length();
        int end = maxPatternLength - margin - margin;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < end) {
            pattern = text.substring(Math.max(0, this.targetStart - (padding += margin)), Math.min(textLength, this.targetStart + this.sourceLength + padding));
        }
        String prefix = text.substring(Math.max(0, this.targetStart - (padding += margin)), this.targetStart);
        int prefixLength = prefix.length();
        if (prefixLength > 0) {
            this.diffs.add(0, new Difference(EditType.EQUAL, prefix));
        }
        if ((suffixLength = (suffix = text.substring(this.targetStart + this.sourceLength, Math.min(textLength, this.targetStart + this.sourceLength + padding))).length()) > 0) {
            this.diffs.add(new Difference(EditType.EQUAL, suffix));
        }
        this.sourceStart -= prefixLength;
        this.targetStart -= prefixLength;
        this.sourceLength += prefixLength + suffixLength;
        this.targetLength += prefixLength + suffixLength;
    }

    public void addDifference(Difference diff) {
        this.diffs.add(diff);
    }

    public int getDifferenceCount() {
        return this.diffs.size();
    }

    public boolean hasDifferences() {
        return !this.diffs.isEmpty();
    }

    @Override
    public Iterator<Difference> iterator() {
        return this.diffs.iterator();
    }

    public Difference getFirstDifference() {
        if (this.diffs.isEmpty()) {
            return null;
        }
        return this.diffs.get(0);
    }

    public Difference removeFirstDifference() {
        if (this.diffs.isEmpty()) {
            return null;
        }
        return this.diffs.remove(0);
    }

    public Difference getLastDifference() {
        if (this.diffs.isEmpty()) {
            return null;
        }
        return this.diffs.get(this.diffs.size() - 1);
    }

    protected void setDifferences(List<Difference> newDiffs) {
        this.diffs = newDiffs;
    }

    public static void setMargin(int newMargin) {
        margin = newMargin;
    }

    public static int getMargin() {
        return margin;
    }

    private String getCoordinates(int start, int length) {
        StringBuilder buf = new StringBuilder();
        if (length == 0) {
            buf.append(start);
            buf.append(",0");
        } else if (length == 1) {
            buf.append(this.sourceStart + 1);
        } else {
            buf.append(start + 1);
            buf.append(',');
            buf.append(length);
        }
        return buf.toString();
    }

    private String encode(String str) {
        int strlen = str.length();
        StringBuilder buf = new StringBuilder(2 * strlen);
        block4: for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '%': {
                    buf.append("%25");
                    continue block4;
                }
                case '\n': {
                    buf.append("%0A");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String decode(String str) {
        int strlen = str.length();
        StringBuilder buf = new StringBuilder(2 * strlen);
        int i = 0;
        for (i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                if ("%0A".equals(str.substring(i, i + 3))) {
                    buf.append('\n');
                } else {
                    buf.append('%');
                }
                i += 2;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

