/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;

public class QuickHelpDialog
extends JDialog {
    private transient ActionFactory actions;
    private JEditorPane txtHelp;
    private static final long serialVersionUID = 3690752899747557426L;

    public QuickHelpDialog(Frame owner, String title, String helpText) {
        super(owner);
        this.initialize();
        this.txtHelp.setText(helpText);
        this.setTitle(title);
    }

    private void initialize() {
        this.actions = new ActionFactory(this);
        this.txtHelp = new JEditorPane();
        this.txtHelp.setEditable(false);
        this.txtHelp.setEditorKit(new HTMLEditorKit());
        this.txtHelp.setMargin(new Insets(5, 5, 0, 5));
        this.txtHelp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ev) {
                QuickHelpDialog.this.close();
            }
        });
        CWScrollPane scrHelp = new CWScrollPane(this.txtHelp);
        scrHelp.setBorder(null);
        JButton btnOK = new JButton(this.actions.addAction("OK", BDMsg.gettext("OK", new Object[0])));
        JPanel pnlOK = new JPanel();
        pnlOK.setLayout(new FlowLayout(4));
        pnlOK.add((Component)btnOK, null);
        pnlOK.setBackground(Color.WHITE);
        pnlOK.setOpaque(true);
        JPanel pnlHelp = new JPanel();
        pnlHelp.setLayout(new BorderLayout());
        pnlHelp.add((Component)scrHelp, "Center");
        pnlHelp.add((Component)pnlOK, "South");
        this.setSize(650, 200);
        this.setModal(true);
        this.setContentPane(pnlHelp);
        this.getRootPane().setDefaultButton(btnOK);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                QuickHelpDialog.this.close();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GuiUtil.centerOnScreen(this);
        }
        super.setVisible(visible);
    }

    public void doOK() {
        this.close();
    }

    public final void close() {
        this.setVisible(false);
    }
}

