/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.AdvancedSearchPane;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.bibledesktop.book.BookSelectEvent;
import org.crosswire.bibledesktop.book.BookSelectListener;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.ParallelBookPicker;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.bibledesktop.book.install.IndexResolver;
import org.crosswire.bibledesktop.passage.KeyChangeEvent;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.QuickHelpDialog;
import org.crosswire.common.swing.desktop.event.TitleChangedEvent;
import org.crosswire.common.swing.desktop.event.TitleChangedListener;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookComparators;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookProvider;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.IndexStatusEvent;
import org.crosswire.jsword.index.IndexStatusListener;
import org.crosswire.jsword.index.search.DefaultSearchModifier;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.index.search.SearchModifier;
import org.crosswire.jsword.index.search.SearchRequest;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RocketPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public class DisplaySelectPane
extends JPanel
implements KeyChangeListener,
BookSelectListener,
BookProvider {
    private transient IndexStatusListener isl;
    private static int base = 1;
    private String title;
    private QuickHelpDialog dlgHelp;
    private transient ActionFactory actions;
    private transient Book[] selected;
    private BibleComboBoxModelSet quickSet;
    private PassageSelectionPane dlgSelect;
    private ParallelBookPicker biblePicker;
    protected JTextField txtKey;
    protected JTextField txtSearch;
    private JButton btnAdvanced;
    private JButton btnSearch;
    private JButton btnKey;
    private JButton btnKeyGo;
    private AdvancedSearchPane advanced;
    private JButton btnIndex;
    private Mode mode;
    protected Key key;
    private transient EventListenerList listeners;
    private static int numRankedVerses = 20;
    private static int maxNumRankedVerses = 200;
    private static final long serialVersionUID = 3256446910616057650L;

    public DisplaySelectPane() {
        this.initialize();
    }

    private void initialize() {
        this.listeners = new EventListenerList();
        this.advanced = new AdvancedSearchPane();
        this.title = BDMsg.gettext("Untitled {0}", base++);
        this.actions = new ActionFactory(this);
        this.isl = new IndexStatusListener(){

            public void statusChanged(IndexStatusEvent ev) {
                DisplaySelectPane.this.enableComponents();
            }
        };
        this.biblePicker = new ParallelBookPicker(BookFilters.getBibles(), BookComparators.getInitialComparator());
        this.biblePicker.addBookListener(this);
        this.selected = this.biblePicker.getBooks();
        if (this.selected != null && this.selected.length > 0) {
            this.selected[0].addIndexStatusListener(this.isl);
            this.key = this.selected[0].createEmptyKeyList();
        } else {
            this.key = new RocketPassage(Versifications.instance().getVersification("KJV"));
        }
        JComboBox cboBooks = new JComboBox();
        JComboBox cboChaps = new JComboBox();
        this.quickSet = new BibleComboBoxModelSet(cboBooks, cboChaps, null);
        this.quickSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BibleComboBoxModelSet set = (BibleComboBoxModelSet)ev.getSource();
                Verse start = set.getVerse();
                BibleBook book = start.getBook();
                int chapter = start.getChapter();
                Versification v11n = KeyUtil.getPassage((Key)DisplaySelectPane.this.key).getVersification();
                VerseRange range = new VerseRange(v11n, start, new Verse(v11n, book, chapter, v11n.getLastVerse(book, chapter)));
                DisplaySelectPane.this.txtSearch.setText("");
                DisplaySelectPane.this.txtKey.setText(range.getName());
                DisplaySelectPane.this.doGoPassage();
            }
        });
        JPanel quickPicker = new JPanel();
        quickPicker.setLayout(new FlowLayout());
        quickPicker.add(cboBooks);
        quickPicker.add(cboChaps);
        JLabel lblBible = CWLabel.createJLabel(BDMsg.gettext("Bible:", new Object[0]));
        lblBible.setLabelFor(this.biblePicker);
        JLabel lblKey = CWLabel.createJLabel(BDMsg.gettext("Show Passage:", new Object[0]));
        CWAction action = this.actions.addAction("PassageAction");
        action.setTooltip(BDMsg.gettext("Enter a passage to display.", new Object[0]));
        this.txtKey = new JTextField();
        this.txtKey.setAction(action);
        this.txtKey.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ev) {
                if (ev.getKeyChar() == '\n' && ev.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                    DisplaySelectPane.this.showSelectDialog();
                }
            }
        });
        action = this.actions.addAction("More", BDMsg.gettext("Select", new Object[0]));
        action.setTooltip(BDMsg.gettext("Pick a passage to display", new Object[0]));
        this.btnKey = new JButton(action);
        action = this.actions.addAction("GoPassage", BDMsg.gettext("Go (passage)", new Object[0]));
        action.setTooltip(BDMsg.gettext("Display the passage", new Object[0]));
        this.btnKeyGo = new JButton(action);
        action = this.actions.addAction("SearchAction");
        action.setTooltip(BDMsg.gettext("Search for a passage.", new Object[0]));
        this.txtSearch = new JTextField();
        this.txtSearch.setAction(action);
        JLabel lblSearch = CWLabel.createJLabel(BDMsg.gettext("Search:", new Object[0]));
        lblSearch.setLabelFor(this.txtSearch);
        action = this.actions.addAction("GoSearch", BDMsg.gettext("Go (search)", new Object[0]));
        action.setTooltip(BDMsg.gettext("Search for a passage.", new Object[0]));
        this.btnSearch = new JButton(action);
        action = this.actions.addAction("HelpAction");
        action.setTooltip(BDMsg.gettext("Quick Search Help", new Object[0]));
        action.setSmallIcon("toolbarButtonGraphics/general/ContextualHelp16.gif");
        JButton btnHelp = GuiUtil.flatten(new JButton(action));
        String dialogTitle = BDMsg.gettext("Search Quick Help", new Object[0]);
        StringBuilder buf = new StringBuilder(200);
        buf.append("<html><b>");
        buf.append(BDMsg.gettext("Search Tips", new Object[0]));
        buf.append("</b><br>");
        buf.append(BDMsg.gettext("You can use || to join phrases, for example <code>balaam || balak</code> finds passages containing Balak OR Balaam", new Object[0]));
        buf.append("<br>");
        buf.append(BDMsg.gettext("Using && requires both words, e.g. <code>aaron && moses</code> finds passages containing both Aaron AND Moses", new Object[0]));
        buf.append("<br>");
        buf.append(BDMsg.gettext("Using a ! removes words from the result e.g. <code>lord ! jesus</code> is passages containing Lord BUT NOT Jesus", new Object[0]));
        buf.append("<br>");
        buf.append(BDMsg.gettext("Using ~2 widens the passage by 2 verses either side on any match. So <code>amminadab ~1 perez</code> finds verses containting Amminadab within 1 verse of mention of Perez.", new Object[0]));
        buf.append("<br>");
        buf.append(BDMsg.gettext("Using +[Gen-Exo] at the beginning will restrict a search to that range of verses.", new Object[0]));
        this.dlgHelp = new QuickHelpDialog(GuiUtil.getFrame(this), dialogTitle, buf.toString());
        action = this.actions.addAction("Advanced", BDMsg.gettext("Advanced", new Object[0]));
        action.setTooltip(BDMsg.gettext("Advanced Search", new Object[0]));
        this.btnAdvanced = new JButton(action);
        action = this.actions.addAction("Index", BDMsg.gettext("Enable Search", new Object[0]));
        action.setTooltip(BDMsg.gettext("Create a search index", new Object[0]));
        this.btnIndex = new JButton(action);
        this.setLayout(new GridBagLayout());
        this.add((Component)lblBible, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 22, 3, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.biblePicker, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)quickPicker, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblKey, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.txtKey, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 1, 2), 0, 0));
        this.add((Component)this.btnKeyGo, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnKey, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 22, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)btnHelp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblSearch, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.btnIndex, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)this.txtSearch, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 3, 2), 0, 0));
        this.add((Component)this.btnSearch, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnAdvanced, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 22, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.enableComponents();
        GuiUtil.applyDefaultOrientation(this);
    }

    public void doInitialTextDisplay() {
        Verse start = this.quickSet.getVerse();
        BibleBook book = start.getBook();
        int chapter = start.getChapter();
        Versification v11n = start.getVersification();
        VerseRange range = new VerseRange(v11n, start, new Verse(v11n, book, chapter, v11n.getLastVerse(book, chapter)));
        this.txtSearch.setText("");
        this.txtKey.setText(range.getName());
        this.doGoPassage();
    }

    public Book[] getBooks() {
        return (Book[])this.selected.clone();
    }

    public Book getFirstBook() {
        return this.selected != null && this.selected.length > 0 ? this.selected[0] : null;
    }

    public void clear() {
        this.setKey((Key)(this.selected == null || this.selected.length == 0 ? new RocketPassage(Versifications.instance().getVersification("KJV")) : this.selected[0].createEmptyKeyList()));
        this.setTitle(Mode.CLEAR);
    }

    public boolean isClear() {
        return this.title.indexOf(BDMsg.gettext("Untitled", new Object[0])) != -1;
    }

    public void doMore() {
        this.showSelectDialog();
    }

    public void doGoPassage() {
        this.doPassageAction();
    }

    public void doGoSearch() {
        this.doSearchAction();
    }

    public void doPassageAction() {
        this.setKey(this.txtKey.getText());
        if (!this.key.isEmpty()) {
            this.txtSearch.setText("");
            this.setTitle(Mode.PASSAGE);
        }
    }

    public void doSearchAction() {
        if (this.selected == null || this.selected.length == 0) {
            this.noBookInstalled();
            return;
        }
        try {
            int partial;
            String param = this.txtSearch.getText();
            if (param == null || param.length() == 0) {
                return;
            }
            boolean rank = this.advanced.isRanked();
            DefaultSearchModifier modifier = new DefaultSearchModifier();
            modifier.setRanked(rank);
            int rankCount = DisplaySelectPane.getNumRankedVerses();
            if (rank && rankCount != 0) {
                modifier.setMaxResults(rankCount);
            }
            Key results = this.selected[0].find((SearchRequest)new DefaultSearchRequest(param, (SearchModifier)modifier));
            int total = partial = results.getCardinality();
            if (results instanceof PassageTally) {
                PassageTally tally = (PassageTally)results;
                total = tally.getTotal();
                tally.setOrdering(PassageTally.Order.TALLY);
            }
            if (total == 0) {
                Reporter.informUser((Object)this, (String)BDMsg.gettext("Could not find verses with: {0}", param));
            } else {
                if (total == partial) {
                    Reporter.informUser((Object)this, (String)BDMsg.gettext("There are {1} verses with: {0}", param, total));
                } else {
                    Reporter.informUser((Object)this, (String)BDMsg.gettext("Showing {1} of {2} verses with: {0}", param, Integer.toString(partial), Integer.toString(total)));
                }
                this.setTitle(Mode.SEARCH);
                this.setKey(results);
            }
        }
        catch (BookException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    public void doAdvanced() {
        String reply = this.advanced.showInDialog(this, BDMsg.gettext("Advanced Search", new Object[0]), true, this.txtSearch.getText());
        if (reply != null) {
            this.txtSearch.setText(reply);
            this.doSearchAction();
        }
    }

    public void doRank() {
    }

    public void doHelpAction() {
        this.dlgHelp.setVisible(true);
    }

    public void doIndex() {
        if (this.selected == null || this.selected.length == 0) {
            this.noBookInstalled();
            return;
        }
        IndexResolver.scheduleIndex(this.selected[0], this);
        this.enableComponents();
    }

    private void updateDisplay() {
        if (this.selected == null || this.selected.length == 0) {
            this.noBookInstalled();
            return;
        }
        this.fireCommandMade(new DisplaySelectEvent(this, this.key));
    }

    public String getTitle() {
        return this.title;
    }

    public ParallelBookPicker getBiblePicker() {
        return this.biblePicker;
    }

    public void setKey(String newKey) {
        if (this.selected == null || this.selected.length == 0) {
            return;
        }
        try {
            this.setKey(this.selected[0].getKey(newKey));
        }
        catch (NoSuchKeyException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void setKey(Key newKey) {
        if (newKey == null || newKey.isEmpty()) {
            if (!this.key.isEmpty()) {
                this.key = this.selected[0].createEmptyKeyList();
                this.txtKey.setText("");
                this.txtSearch.setText("");
                this.updateDisplay();
                this.setTitle(Mode.CLEAR);
            }
        } else if (!newKey.equals((Object)this.key)) {
            this.key = newKey;
            String text = this.key.getName();
            this.txtKey.setText(text);
            this.updateDisplay();
            if (this.isClear()) {
                this.setTitle(Mode.PASSAGE);
                this.txtSearch.setText("");
            }
        }
    }

    public static int getNumRankedVerses() {
        return numRankedVerses;
    }

    public static void setNumRankedVerses(int newNumRankedVerses) {
        int count = newNumRankedVerses;
        if (count < 0) {
            count = 0;
        } else if (count > maxNumRankedVerses) {
            count = maxNumRankedVerses;
        }
        numRankedVerses = count;
    }

    public static int getMaxNumRankedVerses() {
        return maxNumRankedVerses;
    }

    public static void setMaxNumRankedVerses(int newMaxNumRankedVerses) {
        int count = newMaxNumRankedVerses;
        if (count < numRankedVerses) {
            count = numRankedVerses;
        }
        maxNumRankedVerses = count;
    }

    private void setTitle(Mode clear) {
        this.mode = clear;
        switch (this.mode) {
            case CLEAR: {
                this.title = BDMsg.gettext("Untitled {0}", base++);
                break;
            }
            case PASSAGE: {
                this.title = this.key.getName();
                break;
            }
            case SEARCH: {
                this.title = this.txtSearch.getText();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.title.length() == 0) {
            this.setTitle(Mode.CLEAR);
        } else {
            this.fireTitleChanged(new TitleChangedEvent(this, this.title));
        }
    }

    private void noBookInstalled() {
        String noBible = BDMsg.gettext("No Bible is installed", new Object[0]);
        CWOptionPane.showMessageDialog(this, noBible, noBible, 2);
    }

    final void enableComponents() {
        boolean readable = this.selected != null && this.selected.length > 0;
        boolean searchable = readable && this.selected[0].getIndexStatus().equals((Object)IndexStatus.DONE);
        boolean indexable = readable && this.selected[0].getIndexStatus().equals((Object)IndexStatus.UNDONE);
        this.txtSearch.setEnabled(searchable);
        this.txtSearch.setBackground(searchable ? SystemColor.text : SystemColor.control);
        this.txtSearch.setVisible(searchable);
        this.btnAdvanced.setEnabled(searchable);
        this.btnSearch.setEnabled(searchable);
        this.txtKey.setEnabled(readable);
        this.txtKey.setBackground(readable ? SystemColor.text : SystemColor.control);
        this.btnKey.setEnabled(readable);
        this.btnKeyGo.setEnabled(readable);
        this.btnIndex.setVisible(indexable);
        this.btnIndex.setEnabled(indexable);
    }

    final void showSelectDialog() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, BDMsg.gettext("Select Passage", new Object[0]), true, this.txtKey.getText())) != null) {
            this.txtKey.setText(passg);
            this.doPassageAction();
        }
    }

    @Override
    public void booksChosen(BookSelectEvent ev) {
        Book[] books = ev.getBookProvider().getBooks();
        assert (books.length > 0);
        Book newSelected = ev.getBookProvider().getFirstBook();
        if (this.selected.length > 0 && this.selected[0] != newSelected) {
            this.selected[0].removeIndexStatusListener(this.isl);
            newSelected.addIndexStatusListener(this.isl);
        }
        this.selected = books;
        this.enableComponents();
        if (this.selected == null || this.selected.length == 0) {
            this.noBookInstalled();
            return;
        }
        this.fireVersionChanged(new DisplaySelectEvent(this, this.key));
    }

    @Override
    public void keyChanged(KeyChangeEvent ev) {
        this.setKey(ev.getKey());
    }

    public synchronized void addTitleChangedListener(TitleChangedListener li) {
        this.listeners.add(TitleChangedListener.class, li);
    }

    public synchronized void removeTitleChangedListener(TitleChangedListener li) {
        this.listeners.remove(TitleChangedListener.class, li);
    }

    protected void fireTitleChanged(TitleChangedEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != TitleChangedListener.class) continue;
            ((TitleChangedListener)contents[i + 1]).titleChanged(ev);
        }
    }

    public synchronized void addCommandListener(DisplaySelectListener li) {
        this.listeners.add(DisplaySelectListener.class, li);
    }

    public synchronized void removeCommandListener(DisplaySelectListener li) {
        this.listeners.remove(DisplaySelectListener.class, li);
    }

    protected void fireCommandMade(DisplaySelectEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != DisplaySelectListener.class) continue;
            ((DisplaySelectListener)contents[i + 1]).passageSelected(ev);
        }
    }

    protected void fireVersionChanged(DisplaySelectEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != DisplaySelectListener.class) continue;
            ((DisplaySelectListener)contents[i + 1]).bookChosen(ev);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.selected = null;
        this.listeners = new EventListenerList();
        this.actions = new ActionFactory(this);
        this.isl = new IndexStatusListener(){

            public void statusChanged(IndexStatusEvent ev) {
                DisplaySelectPane.this.enableComponents();
            }
        };
        is.defaultReadObject();
    }

    private static enum Mode {
        CLEAR,
        PASSAGE,
        SEARCH;

    }
}

