/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.jsword.index.query.AndNotQuery;
import org.crosswire.jsword.index.query.AndQuery;
import org.crosswire.jsword.index.query.BaseQuery;
import org.crosswire.jsword.index.query.BlurQuery;
import org.crosswire.jsword.index.query.NullQuery;
import org.crosswire.jsword.index.query.Query;
import org.crosswire.jsword.index.query.QueryBuilder;
import org.crosswire.jsword.index.query.RangeQuery;

public final class LuceneQueryBuilder
implements QueryBuilder {
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\s*([-+]?)\\[([^\\[\\]]+)\\]\\s*");
    private static final Pattern BLUR_PATTERN = Pattern.compile("\\s~(\\d*)?\\s");
    private static final Query NULL_QUERY = new NullQuery();

    @Override
    public Query parse(String aSearch) {
        Matcher blurMatcher;
        Query query = NULL_QUERY;
        String sought = aSearch;
        if (sought == null || sought.length() == 0) {
            return query;
        }
        int i = 0;
        RangeQuery range = null;
        String rangeModifier = "";
        Matcher rangeMatcher = RANGE_PATTERN.matcher(sought);
        if (rangeMatcher.find()) {
            rangeModifier = rangeMatcher.group(1);
            range = new RangeQuery(rangeMatcher.group(2));
            sought = sought.replace(rangeMatcher.group(), " ");
        }
        if ((blurMatcher = BLUR_PATTERN.matcher(sought)).find()) {
            int blurFactor = 1;
            String blur = blurMatcher.group(1);
            if (blur.length() > 0) {
                blurFactor = Integer.parseInt(blur);
            }
            BaseQuery left = new BaseQuery(sought.substring(i, blurMatcher.start()));
            BaseQuery right = new BaseQuery(sought.substring(blurMatcher.end()));
            query = new BlurQuery(left, right, blurFactor);
        } else if (sought.length() > 0) {
            query = new BaseQuery(sought);
        }
        if (range != null && !NULL_QUERY.equals(query)) {
            query = rangeModifier.length() == 0 || rangeModifier.charAt(0) == '+' ? new AndQuery(range, query) : new AndNotQuery(query, range);
        }
        return query;
    }
}

