/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.sword.SwordBookDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwordBookPath {
    private static final String DIR_WINDOWS_DEFAULT = "C:\\Program Files\\CrossWire\\The SWORD Project";
    private static final String DIR_SWORD_LIBRARY = "library";
    private static final String DIR_SWORD_CONF = ".sword";
    private static final String DIR_SWORD_CONF_ALT = "Sword";
    private static final String SWORD_GLOBAL_CONF = "sword.conf";
    private static final String DIR_SWORD_GLOBAL_CONF = "/etc:/usr/local/etc";
    private static final String DATA_PATH = "DataPath";
    private static final String AUGMENT_PATH = "AugmentPath";
    private static final String PROPERTY_SWORD_HOME = "sword.home";
    private static final String PROPERTY_USER_HOME = "user.home";
    private static final String PREFIX_GLOBALS = "globals.";
    private static File[] augmentPath = new File[0];
    private static File defaultDownloadDir = SwordBookPath.getDefaultDownloadPath();
    private static File overrideDownloadDir;
    private static final Logger log;

    private SwordBookPath() {
    }

    public static void setAugmentPath(File[] theNewDirs) throws BookException {
        File[] newDirs = theNewDirs;
        if (newDirs == null) {
            return;
        }
        augmentPath = (File[])newDirs.clone();
        Books.installed().registerDriver(SwordBookDriver.instance());
    }

    public static File[] getAugmentPath() {
        return (File[])augmentPath.clone();
    }

    public static File[] getSwordPath() {
        File[] defaultPath;
        ArrayList<File> swordPath = new ArrayList<File>();
        swordPath.add(SwordBookPath.getSwordDownloadDir());
        if (augmentPath != null) {
            for (int i = 0; i < augmentPath.length; ++i) {
                File path = augmentPath[i];
                if (swordPath.contains(path)) continue;
                swordPath.add(path);
            }
        }
        if ((defaultPath = SwordBookPath.getDefaultPaths()) != null) {
            for (int i = 0; i < defaultPath.length; ++i) {
                File path = defaultPath[i];
                if (swordPath.contains(path)) continue;
                swordPath.add(path);
            }
        }
        return swordPath.toArray(new File[swordPath.size()]);
    }

    public static String[] getBookList(File bookDir) {
        return bookDir.list(new CustomFilenameFilter());
    }

    private static File[] getDefaultPaths() {
        SwordBookPath.migrateBookDir();
        ArrayList<File> bookDirs = new ArrayList<File>();
        String home = System.getProperty(PROPERTY_USER_HOME);
        SwordBookPath.readSwordConf(bookDirs, ".");
        SwordBookPath.testDefaultPath(bookDirs, ".");
        SwordBookPath.testDefaultPath(bookDirs, ".." + File.separator + DIR_SWORD_LIBRARY);
        String swordhome = System.getProperty(PROPERTY_SWORD_HOME);
        if (swordhome != null) {
            SwordBookPath.testDefaultPath(bookDirs, swordhome);
            SwordBookPath.testDefaultPath(bookDirs, swordhome + File.separator + ".." + File.separator + DIR_SWORD_LIBRARY);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            SwordBookPath.testDefaultPath(bookDirs, DIR_WINDOWS_DEFAULT);
            SwordBookPath.testDefaultPath(bookDirs, DIR_WINDOWS_DEFAULT + File.separator + ".." + File.separator + DIR_SWORD_LIBRARY);
        }
        SwordBookPath.readSwordConf(bookDirs, home + File.separator + DIR_SWORD_CONF);
        String[] sysconfigPaths = StringUtil.split(DIR_SWORD_GLOBAL_CONF, ':');
        for (int i = 0; i < sysconfigPaths.length; ++i) {
            SwordBookPath.readSwordConf(bookDirs, sysconfigPaths[i]);
        }
        URI userDataArea = OSType.getOSType().getUserAreaFolder(DIR_SWORD_CONF, DIR_SWORD_CONF_ALT);
        SwordBookPath.testDefaultPath(bookDirs, new File(userDataArea.getPath()));
        SwordBookPath.testDefaultPath(bookDirs, new File(CWProject.instance().getWritableProjectDir().getPath()));
        return bookDirs.toArray(new File[bookDirs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readSwordConf(List<File> bookDirs, File swordConfDir) {
        File sysconfig = new File(swordConfDir, SWORD_GLOBAL_CONF);
        if (sysconfig.canRead()) {
            InputStream is = null;
            try {
                PropertyMap prop = new PropertyMap();
                is = new FileInputStream(sysconfig);
                prop.load(is);
                String datapath = prop.get(DATA_PATH);
                SwordBookPath.testDefaultPath(bookDirs, datapath);
                datapath = prop.get(AUGMENT_PATH);
                SwordBookPath.testDefaultPath(bookDirs, datapath);
            }
            catch (IOException ex) {
                log.warn("Failed to read system config file", (Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close system config file", (Throwable)e);
                    }
                }
            }
        }
    }

    private static void readSwordConf(List<File> bookDirs, String swordConfDir) {
        SwordBookPath.readSwordConf(bookDirs, new File(swordConfDir));
    }

    private static void testDefaultPath(List<File> bookDirs, File path) {
        if (path == null) {
            return;
        }
        File mods = new File(path, "mods.d");
        if (mods.isDirectory() && mods.canRead()) {
            bookDirs.add(path);
        }
    }

    private static void testDefaultPath(List<File> bookDirs, String path) {
        if (path == null) {
            return;
        }
        SwordBookPath.testDefaultPath(bookDirs, new File(path));
    }

    private static File getDefaultDownloadPath() {
        File path = null;
        File[] possiblePaths = SwordBookPath.getDefaultPaths();
        if (possiblePaths != null) {
            for (int i = 0; i < possiblePaths.length; ++i) {
                File mods = new File(possiblePaths[i], "mods.d");
                if (!mods.canWrite()) continue;
                path = possiblePaths[i];
                break;
            }
        }
        if (path == null) {
            URI userDataArea = OSType.getOSType().getUserAreaFolder(DIR_SWORD_CONF, DIR_SWORD_CONF_ALT);
            path = new File(userDataArea.getPath());
        }
        return path;
    }

    private static void migrateBookDir() {
        URI userDataArea = OSType.getOSType().getUserAreaFolder(DIR_SWORD_CONF, DIR_SWORD_CONF_ALT);
        File swordBookPath = new File(userDataArea.getPath());
        File oldPath = new File(CWProject.instance().getDeprecatedWritableProjectDir().getPath());
        if (oldPath.isDirectory()) {
            SwordBookPath.migrateBookDir(oldPath, swordBookPath);
            return;
        }
        oldPath = new File(CWProject.instance().getWritableProjectDir().getPath());
        if (oldPath.isDirectory()) {
            SwordBookPath.migrateBookDir(oldPath, swordBookPath);
            return;
        }
        oldPath = new File(OSType.DEFAULT.getUserAreaFolder(DIR_SWORD_CONF, DIR_SWORD_CONF_ALT).getPath());
        if (oldPath.isDirectory()) {
            SwordBookPath.migrateBookDir(oldPath, swordBookPath);
        }
    }

    private static void migrateBookDir(File oldPath, File newPath) {
        File oldDataDir = new File(oldPath, "modules");
        File newDataDir = new File(newPath, "modules");
        File oldConfDir = new File(oldPath, "mods.d");
        File newConfDir = new File(newPath, "mods.d");
        if (!SwordBookPath.migrate(oldDataDir, newDataDir)) {
            return;
        }
        if (!SwordBookPath.migrate(oldConfDir, newConfDir)) {
            SwordBookPath.migrate(newDataDir, oldDataDir);
        }
    }

    private static boolean migrate(File oldPath, File newPath) {
        if (oldPath.equals(newPath) || !oldPath.exists()) {
            return true;
        }
        File parent = newPath.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            return false;
        }
        return oldPath.renameTo(newPath);
    }

    public static File getSwordDownloadDir() {
        if (overrideDownloadDir != null) {
            return overrideDownloadDir;
        }
        return defaultDownloadDir;
    }

    public static File getDownloadDir() {
        return overrideDownloadDir;
    }

    public static void setDownloadDir(File dlDir) {
        if (!"".equals(dlDir.getPath())) {
            overrideDownloadDir = dlDir;
            log.debug("Setting sword download directory to: {}", (Object)dlDir);
        }
    }

    static {
        log = LoggerFactory.getLogger(SwordBookPath.class);
    }

    static class CustomFilenameFilter
    implements FilenameFilter {
        CustomFilenameFilter() {
        }

        @Override
        public boolean accept(File parent, String name) {
            return !name.startsWith(SwordBookPath.PREFIX_GLOBALS) && name.endsWith(".conf");
        }
    }
}

