/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.study;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrongsNumber {
    private char language;
    private int strongsNumber;
    private String part;
    private boolean valid;
    private static final Pattern STRONGS_PATTERN = Pattern.compile("([GgHh])([0-9]*)!?([A-Za-z]+)?");
    private static final DecimalFormat ZERO_PAD = new DecimalFormat("0000");

    public StrongsNumber(String input) {
        this.valid = this.parse(input);
    }

    public StrongsNumber(char language, short strongsNumber) {
        this(language, strongsNumber, null);
    }

    public StrongsNumber(char language, short strongsNumber, String part) {
        this.language = language;
        this.strongsNumber = strongsNumber;
        this.part = part;
        this.valid = this.isValid();
    }

    public String getStrongsNumber() {
        StringBuilder buf = new StringBuilder(5);
        buf.append(this.language);
        buf.append(ZERO_PAD.format(this.strongsNumber));
        return buf.toString();
    }

    public String getFullStrongsNumber() {
        StringBuilder buf = new StringBuilder(5);
        buf.append(this.language);
        buf.append(ZERO_PAD.format(this.strongsNumber));
        if (this.part != null) {
            buf.append(this.part);
        }
        return buf.toString();
    }

    public boolean isGreek() {
        return this.language == 'G';
    }

    public boolean isHebrew() {
        return this.language == 'H';
    }

    public boolean isPart() {
        return this.part != null;
    }

    public boolean isValid() {
        if (!this.valid) {
            return false;
        }
        if (this.language == 'H' && this.strongsNumber >= 1 && this.strongsNumber <= 8674) {
            return true;
        }
        if (this.language == 'G' && (this.strongsNumber >= 1 && this.strongsNumber < 1418 || this.strongsNumber > 1418 && this.strongsNumber < 2717 || this.strongsNumber > 2717 && this.strongsNumber < 3203 || this.strongsNumber > 3302 && this.strongsNumber <= 5624)) {
            return true;
        }
        this.valid = false;
        return false;
    }

    public int hashCode() {
        int result = 31 + this.language;
        return 31 * result + this.strongsNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StrongsNumber other = (StrongsNumber)obj;
        return this.language == other.language && this.strongsNumber == other.strongsNumber;
    }

    public String toString() {
        return this.getStrongsNumber();
    }

    private boolean parse(String input) {
        String text = input;
        this.language = (char)85;
        this.strongsNumber = 9999;
        this.part = "";
        Matcher m = STRONGS_PATTERN.matcher(text);
        if (!m.lookingAt()) {
            return false;
        }
        String lang = m.group(1);
        this.language = lang.charAt(0);
        switch (this.language) {
            case 'g': {
                this.language = (char)71;
                break;
            }
            case 'h': {
                this.language = (char)72;
                break;
            }
        }
        try {
            this.strongsNumber = Integer.parseInt(m.group(2));
        }
        catch (NumberFormatException e) {
            this.strongsNumber = 0;
            return false;
        }
        this.part = m.group(3);
        return true;
    }
}

