/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.processing.NoOpRawTextProcessor;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.IndexStatusEvent;
import org.crosswire.jsword.index.IndexStatusListener;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.index.search.SearchRequest;
import org.crosswire.jsword.index.search.Searcher;
import org.crosswire.jsword.index.search.SearcherFactory;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Document;

public abstract class AbstractBook
implements Book {
    private Searcher searcher;
    private BookMetaData bmd;
    private Backend backend;
    private List<IndexStatusListener> listeners;

    public AbstractBook(BookMetaData bmd, Backend backend) {
        this.bmd = bmd;
        this.backend = backend;
        this.listeners = new CopyOnWriteArrayList<IndexStatusListener>();
    }

    @Override
    public Key getScope() {
        return this.getGlobalKeyList();
    }

    @Override
    public final BookMetaData getBookMetaData() {
        return this.bmd;
    }

    @Override
    public final void setBookMetaData(BookMetaData bmd) {
        this.bmd = bmd;
    }

    public final Backend getBackend() {
        return this.backend;
    }

    @Override
    public void activate(Lock lock) {
    }

    @Override
    public void deactivate(Lock lock) {
    }

    @Override
    public Key find(String request) throws BookException {
        return this.find(new DefaultSearchRequest(request));
    }

    @Override
    public Key find(SearchRequest request) throws BookException {
        if (this.searcher == null) {
            try {
                this.searcher = SearcherFactory.createSearcher(this);
            }
            catch (InstantiationException ex) {
                throw new BookException(JSOtherMsg.lookupText("Failed to initialize the search index", new Object[0]), ex);
            }
        }
        return this.searcher.search(request);
    }

    public Book getBook() {
        return this;
    }

    @Override
    public BookDriver getDriver() {
        return this.bmd == null ? null : this.bmd.getDriver();
    }

    @Override
    public String getDriverName() {
        return this.bmd == null ? null : this.bmd.getDriverName();
    }

    @Override
    public boolean match(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals(this.getInitials())) {
            return true;
        }
        if (name.equals(this.getName())) {
            return true;
        }
        if (name.equalsIgnoreCase(this.getInitials())) {
            return true;
        }
        if (name.equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (name.startsWith(this.getInitials())) {
            return true;
        }
        return name.startsWith(this.getName());
    }

    @Override
    public IndexStatus getIndexStatus() {
        return this.bmd.getIndexStatus();
    }

    @Override
    public void setIndexStatus(IndexStatus newStatus) {
        IndexStatus oldStatus = this.bmd.getIndexStatus();
        this.bmd.setIndexStatus(newStatus);
        this.firePropertyChange(oldStatus, newStatus);
    }

    @Override
    public String getAbbreviation() {
        return this.bmd.getAbbreviation();
    }

    @Override
    public String getInitials() {
        return this.bmd.getInitials();
    }

    @Override
    public Language getLanguage() {
        return this.bmd.getLanguage();
    }

    @Override
    public String getName() {
        return this.bmd.getName();
    }

    @Override
    public String getOsisID() {
        return this.bmd.getOsisID();
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.bmd.getPropertyKeys();
    }

    @Override
    public String getProperty(String key) {
        return this.bmd.getProperty(key);
    }

    @Override
    public void putProperty(String key, String value) {
        this.bmd.putProperty(key, value, false);
    }

    @Override
    public void putProperty(String key, String value, boolean forFrontend) {
        this.bmd.putProperty(key, value, forFrontend);
    }

    @Override
    public BookCategory getBookCategory() {
        return this.bmd.getBookCategory();
    }

    @Override
    public boolean isLeftToRight() {
        return this.bmd.isLeftToRight();
    }

    @Override
    public boolean isSupported() {
        return this.bmd.isSupported();
    }

    @Override
    public boolean isEnciphered() {
        return this.bmd.isEnciphered();
    }

    @Override
    public boolean isLocked() {
        return this.bmd.isLocked();
    }

    @Override
    public boolean unlock(String unlockKey) {
        boolean state = this.bmd.unlock(unlockKey);
        if (state) {
            return this.isUnlockKeyValid();
        }
        return state;
    }

    private boolean isUnlockKeyValid() {
        try {
            Key key = this.getGlobalKeyList();
            if (key == null) {
                return true;
            }
            if (key.getCardinality() > 0) {
                key = key.get(0);
            }
            this.getOsis(key, new NoOpRawTextProcessor());
            return true;
        }
        catch (BookException ex) {
            return false;
        }
    }

    protected abstract List<Content> getOsis(Key var1, RawTextToXmlProcessor var2) throws BookException;

    @Override
    public String getUnlockKey() {
        return this.bmd.getUnlockKey();
    }

    @Override
    public boolean isQuestionable() {
        return this.bmd.isQuestionable();
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        return this.bmd.hasFeature(feature);
    }

    @Override
    public void addIndexStatusListener(IndexStatusListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IndexStatusListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeIndexStatusListener(IndexStatusListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void firePropertyChange(IndexStatus oldStatus, IndexStatus newStatus) {
        if (oldStatus != null && newStatus != null && oldStatus.equals((Object)newStatus)) {
            return;
        }
        IndexStatusEvent ev = new IndexStatusEvent(this, newStatus);
        for (IndexStatusListener listener : this.listeners) {
            listener.statusChanged(ev);
        }
    }

    @Override
    public Document toOSIS() {
        return this.bmd.toOSIS();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Book that = (Book)obj;
        return this.bmd.equals(that.getBookMetaData());
    }

    public int hashCode() {
        return this.bmd.hashCode();
    }

    @Override
    public int compareTo(Book obj) {
        return this.bmd.compareTo(obj.getBookMetaData());
    }

    public String toString() {
        return this.bmd.toString();
    }
}

