/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CWProject {
    private static final String DIR_NETCACHE = "netcache";
    private URI[] homes;
    private URI writeHome;
    private String frontendName;
    private URI readHome;
    private URI writableFrontEndHome;
    private URI frontendReadHome;
    private static String homeProperty = "jsword.home";
    private static String homeDirectory = ".jsword";
    private static String homeAltDirectory = "JSword";
    private static CWProject instance = new CWProject();
    private static final Logger LOGGER = LoggerFactory.getLogger(CWProject.class);

    public static CWProject instance() {
        return instance;
    }

    private static void reset() {
        instance = new CWProject();
    }

    public static void setHome(String homeProperty, String homeDir, String altHomeDir) {
        CWProject.homeProperty = homeProperty;
        homeDirectory = homeDir;
        homeAltDirectory = altHomeDir;
        CWProject.instance().establishProjectHome();
    }

    public void setFrontendName(String frontendName) {
        this.frontendName = frontendName;
    }

    public URI getWritableFrontendProjectDir() {
        this.establishProjectHome();
        return this.writableFrontEndHome;
    }

    public URI getReadableFrontendProjectDir() {
        this.establishProjectHome();
        return this.frontendReadHome;
    }

    public URI getWritableProjectDir() {
        this.establishProjectHome();
        return this.writeHome;
    }

    public URI[] getProjectResourceDirs() {
        this.establishProjectHome();
        return (URI[])this.homes.clone();
    }

    public URI getDeprecatedWritableProjectDir() {
        return OSType.DEFAULT.getUserAreaFolder(homeDirectory, homeAltDirectory);
    }

    public URI getWritableURI(String subject, String extension) {
        return NetUtil.lengthenURI(this.getWritableProjectDir(), subject + extension);
    }

    public URI getWritableProjectSubdir(String subject, boolean create) throws IOException {
        URI temp = NetUtil.lengthenURI(this.getWritableProjectDir(), subject);
        if (create && !NetUtil.isDirectory(temp)) {
            NetUtil.makeDirectory(temp);
        }
        return temp;
    }

    private CWProject() {
    }

    private void establishProjectHome() {
        String cwHome;
        if (this.writeHome == null && this.readHome == null && (cwHome = System.getProperty(homeProperty)) != null) {
            URI home = NetUtil.getURI(new File(cwHome));
            if (NetUtil.canWrite(home)) {
                this.writeHome = home;
            } else if (NetUtil.canRead(home)) {
                this.readHome = home;
            }
        }
        if (this.writeHome == null) {
            URI path = OSType.getOSType().getUserAreaFolder(homeDirectory, homeAltDirectory);
            URI oldPath = this.getDeprecatedWritableProjectDir();
            this.writeHome = this.migrateUserProjectDir(oldPath, path);
        }
        if (this.homes == null) {
            this.homes = this.readHome == null ? new URI[]{this.writeHome} : new URI[]{this.writeHome, this.readHome};
            CWClassLoader.setHome(this.getProjectResourceDirs());
            try {
                URI uricache = this.getWritableProjectSubdir(DIR_NETCACHE, true);
                File filecache = new File(uricache.getPath());
                NetUtil.setURICacheDir(filecache);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to get directory for NetUtil.setURICacheDir()", (Throwable)ex);
            }
            try {
                if (this.frontendName != null) {
                    this.writableFrontEndHome = this.getWritableProjectSubdir(this.frontendName, true);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to create writable front-end home.", (Throwable)ex);
            }
            if (this.readHome != null && this.frontendName != null) {
                this.frontendReadHome = NetUtil.lengthenURI(this.readHome, this.frontendName);
            }
        }
    }

    private URI migrateUserProjectDir(URI oldPath, URI newPath) {
        if (oldPath.toString().equals(newPath.toString())) {
            return newPath;
        }
        if (NetUtil.isDirectory(oldPath)) {
            File oldDir = new File(oldPath.getPath());
            File newDir = new File(newPath.getPath());
            if (!NetUtil.isDirectory(newPath)) {
                if (oldDir.renameTo(newDir)) {
                    return newPath;
                }
                return oldPath;
            }
        }
        return newPath;
    }
}

