/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.view.web;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadSet
implements Comparable<DownloadSet> {
    public static final String BIN_ZIP = "-bin.zip";
    public static final String BIN_TGZ = "-bin.tar.gz";
    public static final String LATEST = "latest-bin.zip";
    public static final String SRC_ZIP = "-src.zip";
    public static final String SRC_TGZ = "-src.tar.gz";
    public static final String DOC_ZIP = "-doc.zip";
    public static final String DOC_TGZ = "-doc.tar.gz";
    private boolean datesort;
    private String webprefix;
    private String localprefix;
    private String setname;
    private static final String TEST_PREFIX = "jsword-";
    private static final NumberFormat NF = NumberFormat.getNumberInstance();
    private static final String VERSION_DATE = "yyyyMMdd";
    private static final DateFormat DF_DISK = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat DF_USER = new SimpleDateFormat("dd MMM yyyy");
    protected static final Logger log;

    public static DownloadSet[] getDownloadSets(String localprefix, String webprefix, boolean datesort) throws IOException {
        File dir = new File(localprefix);
        if (!dir.isDirectory()) {
            log.error("{} is not a directory", (Object)localprefix);
            throw new IOException(MessageFormat.format("{0} is not a directory", localprefix));
        }
        log.debug("dig {}", (Object)localprefix);
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                log.debug("Examine file: {}", (Object)name);
                return file.canRead() && name.startsWith(DownloadSet.TEST_PREFIX) && name.endsWith(DownloadSet.BIN_ZIP) && !name.endsWith(DownloadSet.LATEST);
            }
        });
        TreeSet<DownloadSet> reply = new TreeSet<DownloadSet>();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            log.debug("adding {}", (Object)name);
            String sets = name.substring(TEST_PREFIX.length(), name.length() - BIN_ZIP.length());
            reply.add(new DownloadSet(localprefix, webprefix, sets, datesort));
        }
        return reply.toArray(new DownloadSet[reply.size()]);
    }

    private DownloadSet(String localprefix, String webprefix, String setname, boolean datesort) {
        this.localprefix = localprefix;
        this.webprefix = webprefix;
        this.setname = setname;
        this.datesort = datesort;
        log.debug("ctor {}", (Object)webprefix);
    }

    @Override
    public int compareTo(DownloadSet that) {
        if (this.datesort) {
            try {
                String thisSetdate = this.setname.substring(this.setname.length() - VERSION_DATE.length());
                Date thisdate = DF_DISK.parse(thisSetdate);
                String thatSetdate = that.setname.substring(that.setname.length() - VERSION_DATE.length());
                Date thatdate = DF_DISK.parse(thatSetdate);
                return thisdate.compareTo(thatdate);
            }
            catch (ParseException ex) {
                log.error("Failed to parse dates", (Throwable)ex);
                return 0;
            }
        }
        return that.setname.compareTo(this.setname);
    }

    public String getDateString() throws ParseException {
        String setdate = this.setname.substring(this.setname.length() - VERSION_DATE.length());
        Date date = DF_DISK.parse(setdate);
        return DF_USER.format(date);
    }

    public String getVersionString() {
        return MessageFormat.format("Version {0}", this.setname);
    }

    public String getLinkString(String extension) {
        File file = new File(this.localprefix, TEST_PREFIX + this.setname + extension);
        String size = NF.format((float)file.length() / 1048576.0f);
        String reply = "<a href='" + this.webprefix + '/' + TEST_PREFIX + this.setname + extension + "'>" + size + " Mb</a>";
        log.debug("link={}", (Object)reply);
        return reply;
    }

    static {
        NF.setMaximumFractionDigits(2);
        log = LoggerFactory.getLogger(DownloadSet.class);
    }
}

