/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.KeyValuePair;
import org.crosswire.common.util.LucidRuntimeException;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.OsisParser;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.FileVersificationMapping;
import org.crosswire.jsword.versification.QualifiedKey;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersificationToKJVMapper {
    private Versification nonKjv;
    private Passage absentVerses;
    private Map<VerseKey, List<QualifiedKey>> toKJVMappings;
    private Map<QualifiedKey, Passage> fromKJVMappings;
    private boolean hasErrors;
    private OsisParser osisParser = new OsisParser();
    private static final Versification KJV = Versifications.instance().getVersification("KJV");
    private static final Logger LOGGER = LoggerFactory.getLogger(VersificationToKJVMapper.class);

    public VersificationToKJVMapper(Versification nonKjv, FileVersificationMapping mapping) {
        this.absentVerses = this.createEmptyPassage(KJV);
        this.toKJVMappings = new HashMap<VerseKey, List<QualifiedKey>>();
        this.fromKJVMappings = new HashMap<QualifiedKey, Passage>();
        this.nonKjv = nonKjv;
        this.processMappings(mapping);
        this.trace();
    }

    private void processMappings(FileVersificationMapping mappings) {
        List<KeyValuePair> entries = mappings.getMappings();
        for (KeyValuePair entry : entries) {
            try {
                this.processEntry(entry);
            }
            catch (NoSuchKeyException ex) {
                LOGGER.error("Unable to process entry [{}] with value [{}]", new Object[]{entry.getKey(), entry.getValue(), ex});
                this.hasErrors = true;
            }
        }
    }

    private void processEntry(KeyValuePair entry) throws NoSuchKeyException {
        String leftHand = entry.getKey();
        String kjvHand = entry.getValue();
        if (leftHand == null || leftHand.length() == 0) {
            LOGGER.error("Left hand must have content");
            return;
        }
        if ("!zerosUnmapped".equals(leftHand)) {
            return;
        }
        QualifiedKey left = this.getRange(this.nonKjv, leftHand, null);
        QualifiedKey kjv = this.getRange(KJV, kjvHand, left.getKey());
        this.addMappings(left, kjv);
    }

    private void addMappings(QualifiedKey leftHand, QualifiedKey kjvVerses) throws NoSuchVerseException {
        if (leftHand.getAbsentType() == QualifiedKey.Qualifier.ABSENT_IN_LEFT) {
            this.absentVerses.addAll(kjvVerses.getKey());
        } else if (leftHand.getKey().getCardinality() == 1) {
            this.add1ToManyMappings(leftHand.getVerse(), kjvVerses);
        } else {
            this.addManyToMany(leftHand, kjvVerses);
        }
    }

    private void addManyToMany(QualifiedKey leftHand, QualifiedKey kjvVerses) {
        VerseKey leftKeys = leftHand.getKey();
        VerseKey kjvKeys = kjvVerses.getKey();
        Iterator leftIter = leftKeys.iterator();
        if (kjvKeys != null && kjvKeys.getCardinality() != 1) {
            int diff = Math.abs(leftKeys.getCardinality() - kjvKeys.getCardinality());
            if (diff > 1) {
                this.reportCardinalityError(leftKeys, kjvKeys);
            }
            boolean skipVerse0 = diff == 1;
            Iterator kjvIter = kjvKeys.iterator();
            while (leftIter.hasNext()) {
                Verse leftVerse = (Verse)leftIter.next();
                if (!kjvIter.hasNext()) {
                    this.reportCardinalityError(leftKeys, kjvKeys);
                }
                Verse rightVerse = (Verse)kjvIter.next();
                QualifiedKey kjvKey = new QualifiedKey(rightVerse);
                if (skipVerse0 && leftVerse.getVerse() == 0) {
                    this.addForwardMappingFromSingleKeyToRange(leftVerse, kjvKey);
                    this.addKJVToMapping(kjvKey, leftVerse);
                    if (!leftIter.hasNext()) {
                        this.reportCardinalityError(leftKeys, kjvKeys);
                    }
                    leftVerse = (Verse)leftIter.next();
                }
                if (skipVerse0 && rightVerse.getVerse() == 0) {
                    this.addForwardMappingFromSingleKeyToRange(leftVerse, kjvKey);
                    this.addKJVToMapping(kjvKey, leftVerse);
                    if (!kjvIter.hasNext()) {
                        this.reportCardinalityError(leftKeys, kjvKeys);
                    }
                    rightVerse = (Verse)kjvIter.next();
                    kjvKey = new QualifiedKey(rightVerse);
                }
                this.addForwardMappingFromSingleKeyToRange(leftVerse, kjvKey);
                this.addKJVToMapping(kjvKey, leftVerse);
            }
            if (kjvIter.hasNext()) {
                this.reportCardinalityError(leftKeys, kjvKeys);
            }
        } else {
            while (leftIter.hasNext()) {
                Verse leftKey = (Verse)leftIter.next();
                this.addForwardMappingFromSingleKeyToRange(leftKey, kjvVerses);
                this.addKJVToMapping(kjvVerses, leftKey);
            }
        }
    }

    private void reportCardinalityError(VerseKey leftKeys, VerseKey kjvKeys) {
        throw new LucidRuntimeException(String.format("%s has a cardinality of %s whilst %s has a cardinality of %s.", leftKeys, Integer.toString(leftKeys.getCardinality()), kjvKeys, Integer.toString(kjvKeys.getCardinality())));
    }

    private void addKJVToMapping(QualifiedKey kjvVerses, Verse leftKey) {
        if (leftKey != null) {
            this.getNonEmptyKey(this.fromKJVMappings, kjvVerses).addAll(leftKey);
            if (!kjvVerses.isWhole()) {
                this.getNonEmptyKey(this.fromKJVMappings, QualifiedKey.create(kjvVerses.getKey().getWhole())).addAll(leftKey);
            }
        }
    }

    private void add1ToManyMappings(Verse leftHand, QualifiedKey kjvHand) throws NoSuchVerseException {
        this.addForwardMappingFromSingleKeyToRange(leftHand, kjvHand);
        this.addReverse1ToManyMappings(leftHand, kjvHand);
    }

    private void addReverse1ToManyMappings(Verse leftHand, QualifiedKey kjvHand) {
        if (kjvHand.getAbsentType() == QualifiedKey.Qualifier.ABSENT_IN_KJV || kjvHand.getKey().getCardinality() == 1) {
            this.addKJVToMapping(kjvHand, leftHand);
        } else {
            Iterator kjvKeys = kjvHand.getKey().iterator();
            while (kjvKeys.hasNext()) {
                this.addKJVToMapping(new QualifiedKey(KeyUtil.getVerse((Key)kjvKeys.next())), leftHand);
            }
        }
    }

    private void addForwardMappingFromSingleKeyToRange(Verse leftHand, QualifiedKey kjvHand) {
        if (leftHand == null) {
            return;
        }
        this.getNonEmptyMappings(this.toKJVMappings, leftHand).add(kjvHand);
    }

    private VerseKey getNonEmptyKey(Map<QualifiedKey, Passage> mappings, QualifiedKey key) {
        Passage matchingVerses = mappings.get(key);
        if (matchingVerses == null) {
            matchingVerses = this.createEmptyPassage(this.nonKjv);
            mappings.put(key, matchingVerses);
        }
        return matchingVerses;
    }

    private <T, S> List<S> getNonEmptyMappings(Map<T, List<S>> mappings, T key) {
        List<S> matchingVerses = mappings.get(key);
        if (matchingVerses == null) {
            matchingVerses = new ArrayList<S>();
            mappings.put(key, matchingVerses);
        }
        return matchingVerses;
    }

    private QualifiedKey getRange(Versification versification, String versesKey, VerseKey offsetBasis) throws NoSuchKeyException {
        if (versesKey == null || versesKey.length() == 0) {
            throw new NoSuchKeyException(JSMsg.gettext("Cannot understand [{0}] as a chapter or verse.", versesKey));
        }
        char firstChar = versesKey.charAt(0);
        switch (firstChar) {
            case '?': {
                return this.getAbsentQualifiedKey(versification, versesKey);
            }
            case '+': 
            case '-': {
                return this.getOffsetQualifiedKey(versification, versesKey, offsetBasis);
            }
        }
        return this.getExistingQualifiedKey(versification, versesKey);
    }

    private QualifiedKey getOffsetQualifiedKey(Versification versification, String versesKey, VerseKey offsetBasis) throws NoSuchKeyException {
        Iterator<VerseRange> iter;
        if (offsetBasis == null || offsetBasis.getCardinality() == 0) {
            throw new NoSuchKeyException(JSMsg.gettext("Unable to offset the given key [{0}]", offsetBasis));
        }
        int offset = Integer.parseInt(versesKey.substring(1));
        VerseRange vr = null;
        if (offsetBasis instanceof VerseRange) {
            vr = (VerseRange)offsetBasis;
        } else if (offsetBasis instanceof Passage && (iter = ((Passage)offsetBasis).rangeIterator(RestrictionType.NONE)).hasNext()) {
            vr = iter.next();
        }
        if (vr == null) {
            throw new NoSuchKeyException(JSMsg.gettext("Unable to offset the given key [{0}]", offsetBasis));
        }
        Verse vrStart = vr.getStart();
        Verse start = vrStart.reversify(versification);
        if (offset < 0) {
            start = versification.subtract(start, -offset);
        } else if (offset > 0) {
            start = versification.add(start, offset);
        }
        Verse end = start;
        if (vr.getCardinality() > 1) {
            end = versification.add(start, vr.getCardinality() - 1);
        }
        if (start == null || end == null) {
            this.hasErrors = true;
            LOGGER.error("Verse range with offset did not map to correct range in target versification. This mapping will be set to an empty unmapped key.");
        }
        return start != null && end != null ? new QualifiedKey(new VerseRange(versification, start, end)) : new QualifiedKey(versesKey);
    }

    private QualifiedKey getExistingQualifiedKey(Versification versification, String versesKey) {
        return new QualifiedKey(this.osisParser.parseOsisRef(versification, versesKey));
    }

    private QualifiedKey getAbsentQualifiedKey(Versification versification, String versesKey) {
        if (versification.equals(this.nonKjv)) {
            return new QualifiedKey();
        }
        return new QualifiedKey(versesKey);
    }

    private List<QualifiedKey> getQualifiedKeys(Key leftKey) {
        return this.toKJVMappings.get(leftKey);
    }

    public List<QualifiedKey> map(QualifiedKey qualifiedKey) {
        VerseKey key = qualifiedKey.getKey();
        if (key instanceof Verse) {
            List<QualifiedKey> kjvKeys = this.getQualifiedKeys(key);
            if (kjvKeys == null || kjvKeys.size() == 0) {
                kjvKeys = new ArrayList<QualifiedKey>();
                kjvKeys.add(qualifiedKey.reversify(KJV));
                return kjvKeys;
            }
            return kjvKeys;
        }
        return new ArrayList<QualifiedKey>();
    }

    public VerseKey unmap(QualifiedKey kjvVerse) {
        Passage left = this.fromKJVMappings.get(kjvVerse);
        if (left == null && !kjvVerse.isWhole()) {
            left = this.fromKJVMappings.get(new QualifiedKey(kjvVerse.getVerse().getWhole()));
        }
        if (left == null) {
            VerseKey vk = kjvVerse.getKey();
            if (vk != null && this.absentVerses.contains(vk)) {
                return this.createEmptyPassage(KJV);
            }
            return kjvVerse.reversify(this.nonKjv).getKey();
        }
        return left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace() {
        if (LOGGER.isTraceEnabled()) {
            PrintStream ps = null;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ps = new PrintStream(os);
                this.dump(ps);
                String output = os.toString("UTF8");
                LOGGER.trace(output);
            }
            catch (UnsupportedEncodingException e) {
                try {
                    LOGGER.error("Encoding UTF8 not supported.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(ps);
                    throw throwable;
                }
                IOUtil.close(ps);
            }
            IOUtil.close(ps);
        }
    }

    public void dump(PrintStream out) {
        String nonKjvName = this.nonKjv.getName();
        out.println("##############################");
        out.print(String.format("Mapping between KJV and %s", nonKjvName));
        out.println("##############################");
        out.println("    ******************************");
        out.println("    Forward mappings towards KJV");
        out.println("    ******************************");
        for (Map.Entry<VerseKey, List<QualifiedKey>> entry : this.toKJVMappings.entrySet()) {
            List<QualifiedKey> kjvVerses = entry.getValue();
            String osisRef = entry.getKey().getOsisRef();
            for (QualifiedKey q : kjvVerses) {
                out.println(String.format("\t(%s) %s => (KJV) %s", nonKjvName, osisRef, q.toString()));
            }
        }
        out.println("    ******************************");
        out.println("    Absent verses in left versification:");
        out.println(String.format("\t[%s]", this.absentVerses.getOsisRef()));
        out.println("    ******************************");
        out.println("    Backwards mappings from KJV");
        out.println("    ******************************");
        for (Map.Entry<Object, Iterable<QualifiedKey>> entry : this.fromKJVMappings.entrySet()) {
            out.println(String.format("\t(KJV): %s => (%s) %s", ((QualifiedKey)entry.getKey()).toString(), nonKjvName, ((Passage)entry.getValue()).getOsisRef()));
        }
    }

    boolean hasErrors() {
        return this.hasErrors;
    }

    private Passage createEmptyPassage(Versification versification) {
        return new RangedPassage(versification);
    }
}

