/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.KeyFilter;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class XRefAnalyzer
extends AbstractBookAnalyzer {
    public XRefAnalyzer() {
    }

    public XRefAnalyzer(Book book) {
        this.setBook(book);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new KeyFilter(this.getBook(), (TokenStream)new WhitespaceTokenizer(reader));
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new WhitespaceTokenizer(reader));
            streams.setResult((TokenStream)new KeyFilter(this.getBook(), streams.getResult()));
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }
}

