/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class GreekLuceneAnalyzer
extends AbstractBookAnalyzer {
    private final Version matchVersion = Version.LUCENE_29;

    public GreekLuceneAnalyzer() {
        this.stopSet = GreekAnalyzer.getDefaultStopSet();
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(this.matchVersion, reader);
        result = new GreekLowerCaseFilter((TokenStream)result);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new StandardTokenizer(this.matchVersion, reader));
            streams.setResult((TokenStream)new GreekLowerCaseFilter(streams.getResult()));
            if (this.doStopWords && this.stopSet != null) {
                streams.setResult((TokenStream)new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.getResult(), this.stopSet));
            }
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }
}

