/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.crosswire.common.util.IOUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.RawBackendState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileBackendState
extends RawBackendState {
    public static final String INCFILE = "incfile";
    private File incfile;
    private int incfileValue = -1;
    private static final Logger log = LoggerFactory.getLogger(RawFileBackendState.class);

    RawFileBackendState(SwordBookMetaData bookMetaData) throws BookException {
        super(bookMetaData);
    }

    @Override
    public boolean isWritable() {
        File incFile = this.getIncfile();
        return this.existsAndCanReadAndWrite(this.otTextFile) && this.existsAndCanReadAndWrite(this.ntTextFile) && this.existsAndCanReadAndWrite(this.otIdxFile) && this.existsAndCanReadAndWrite(this.otTextFile) && (incFile == null || this.existsAndCanReadAndWrite(incFile));
    }

    private boolean existsAndCanReadAndWrite(File file) {
        return file.exists() && file.canRead() && file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readIncfile() throws IOException {
        int ret = -1;
        if (this.incfile == null) {
            this.initIncFile();
        }
        if (this.incfile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.incfile);
                byte[] buffer = new byte[4];
                if (fis.read(buffer) != 4) {
                    log.error("Read data is not of appropriate size of 4 bytes!");
                    throw new IOException("Incfile is not 4 bytes long");
                }
                this.incfileValue = ret = SwordUtil.decodeLittleEndian32(buffer, 0);
            }
            catch (FileNotFoundException e) {
                try {
                    log.error("Error on writing to incfile, file should exist already!: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    throw throwable;
                }
                IOUtil.close(fis);
            }
            IOUtil.close(fis);
        }
        return ret;
    }

    private void initIncFile() {
        try {
            File tempIncfile = new File(SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath() + File.separator + INCFILE);
            if (tempIncfile.exists()) {
                this.incfile = tempIncfile;
            }
        }
        catch (BookException e) {
            log.error("Error on checking incfile: {}", (Object)e.getMessage(), (Object)e);
            this.incfile = null;
        }
    }

    public int getIncfileValue() {
        if (this.incfileValue == -1) {
            try {
                this.readIncfile();
            }
            catch (IOException e) {
                log.error("IO Error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.incfileValue;
    }

    public void setIncfileValue(int incValue) {
        this.incfileValue = incValue;
    }

    public File getIncfile() {
        if (this.incfile == null) {
            this.initIncFile();
        }
        return this.incfile;
    }

    public void setIncfile(File incfile) {
        this.incfile = incfile;
    }
}

