/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.crypt.Sapphire;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.StatefulFileBackedBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.jdom2.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackend<T extends OpenFileState>
implements StatefulFileBackedBackend<T>,
Backend<T> {
    private SwordBookMetaData bmd;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBackend.class);

    public AbstractBackend() {
    }

    public AbstractBackend(SwordBookMetaData sbmd) {
        this.bmd = sbmd;
    }

    @Override
    public SwordBookMetaData getBookMetaData() {
        return this.bmd;
    }

    @Override
    public void decipher(byte[] data) {
        String cipherKeyString = this.getBookMetaData().getProperty("CipherKey");
        if (cipherKeyString != null) {
            Sapphire cipherEngine = new Sapphire(cipherKeyString.getBytes());
            for (int i = 0; i < data.length; ++i) {
                data[i] = cipherEngine.cipher(data[i]);
            }
            cipherEngine.burn();
        }
    }

    @Override
    public void encipher(byte[] data) {
        this.decipher(data);
    }

    @Override
    public Key readIndex() {
        return null;
    }

    @Override
    public abstract boolean contains(Key var1);

    @Override
    public String getRawText(Key key) throws BookException {
        OpenFileState state = null;
        try {
            state = (OpenFileState)this.initState();
            String string = this.readRawContent(state, key);
            return string;
        }
        catch (IOException e) {
            throw new BookException("Unable to obtain raw content from backend", e);
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        OpenFileState state = null;
        try {
            state = (OpenFileState)this.initState();
            this.setAliasKey(state, alias, source);
        }
        catch (IOException e) {
            throw new BookException(JSOtherMsg.lookupText("Unable to save {0}.", alias.getOsisID()));
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    @Override
    public int getRawTextLength(Key key) {
        try {
            String raw = this.getRawText(key);
            return raw == null ? 0 : raw.length();
        }
        catch (BookException e) {
            return 0;
        }
    }

    @Override
    public Key getGlobalKeyList() throws BookException {
        throw new UnsupportedOperationException("Fast global key list unsupported in this backend");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> readToOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        ArrayList<Content> content = new ArrayList<Content>();
        OpenFileState openFileState = null;
        try {
            openFileState = (OpenFileState)this.initState();
            switch (this.bmd.getKeyType()) {
                case LIST: {
                    this.readNormalOsis(key, processor, content, openFileState);
                    break;
                }
                case TREE: {
                    this.readNormalOsisSingleKey(key, processor, content, openFileState);
                    break;
                }
                case VERSE: {
                    this.readPassageOsis(key, processor, content, openFileState);
                    break;
                }
                default: {
                    throw new BookException("Book has unsupported type of key");
                }
            }
            ArrayList<Content> arrayList = content;
            return arrayList;
        }
        finally {
            OpenFileStateManager.instance().release(openFileState);
        }
    }

    private void readNormalOsis(Key key, RawTextToXmlProcessor processor, List<Content> content, T openFileState) throws BookException {
        for (Key next : key) {
            try {
                String rawText = this.readRawContent(openFileState, next);
                processor.postVerse(next, content, rawText);
            }
            catch (IOException e) {
                this.throwFailedKeyException(key, next, e);
            }
        }
    }

    private void readNormalOsisSingleKey(Key key, RawTextToXmlProcessor processor, List<Content> content, T openFileState) throws BookException {
        try {
            String rawText = this.readRawContent(openFileState, key);
            processor.postVerse(key, content, rawText);
        }
        catch (IOException e) {
            this.throwFailedKeyException(key, key, e);
        }
    }

    private Verse readPassageOsis(Key key, RawTextToXmlProcessor processor, List<Content> content, T openFileState) throws BookException {
        Verse currentVerse = null;
        Passage ref = KeyUtil.getPassage(key);
        Iterator<VerseRange> rit = ref.rangeIterator(RestrictionType.CHAPTER);
        while (rit.hasNext()) {
            VerseRange range = rit.next();
            processor.preRange(range, content);
            for (Key verseInRange : range) {
                currentVerse = KeyUtil.getVerse(verseInRange);
                try {
                    String rawText = this.readRawContent(openFileState, currentVerse);
                    processor.postVerse(verseInRange, content, rawText);
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return currentVerse;
    }

    private void throwFailedKeyException(Key masterKey, Key currentKey, IOException e) throws BookException {
        if (currentKey == null) {
            throw new BookException(JSMsg.gettext("Error reading {0}", masterKey.getName()), e);
        }
        throw new BookException(JSMsg.gettext("Error reading {0}", currentKey.getName()), e);
    }

    @Override
    public void create() throws IOException, BookException {
        File dataPath = new File(SwordUtil.getExpandedDataPath(this.getBookMetaData()));
        if (!dataPath.exists() && !dataPath.mkdirs()) {
            throw new IOException("Unable to create module data path!");
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }
}

