/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.osis;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class OSISFilter
implements Filter {
    private BlockingQueue<SAXBuilder> saxBuilders = new ArrayBlockingQueue<SAXBuilder>(32);
    private static final Pattern DIV_START = Pattern.compile("<div>", 16);
    private static final Pattern DIV_END = Pattern.compile("</div>", 16);
    private static final Pattern CHAPTER_END = Pattern.compile("</chapter>", 16);
    private static final Pattern SPEECH_START = Pattern.compile("<speech>", 16);
    private static final Pattern SPEECH_END = Pattern.compile("</speech>", 16);

    @Override
    public List<Content> toOSIS(Book book, Key key, String plain) {
        String reclosed;
        String cleanedEntities;
        Element ele = null;
        Throwable ex = null;
        String clean = plain;
        clean = DIV_START.matcher(clean).replaceAll("<div sID=\"xyz\"/>");
        clean = DIV_END.matcher(clean).replaceAll("<div eID=\"xyz\"/>");
        clean = CHAPTER_END.matcher(clean).replaceAll("<chapter eID=\"xyz\"/>");
        clean = SPEECH_START.matcher(clean).replaceAll("<speech sID=\"xyz\"/>");
        clean = SPEECH_END.matcher(clean).replaceAll("<speech eID=\"xyz\"/>");
        if ("MapM".equals(book.getInitials())) {
            for (String tag : Arrays.asList("cell", "row", "table")) {
                int startPos = clean.indexOf("<" + tag + ">");
                int endPos = clean.indexOf("</" + tag + ">");
                if (endPos == -1 || startPos != -1 && startPos <= endPos) continue;
                clean = "<" + tag + ">" + clean;
            }
        }
        try {
            ele = this.parse(clean);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        if (ele == null && (cleanedEntities = XMLUtil.cleanAllEntities(clean)) != null && !cleanedEntities.equals(clean)) {
            clean = cleanedEntities;
            try {
                ele = this.parse(clean);
                ex = null;
            }
            catch (JDOMException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ele == null && (reclosed = XMLUtil.recloseTags(clean)) != null && !reclosed.equals(clean)) {
            clean = reclosed;
            try {
                ele = this.parse(clean);
                ex = null;
            }
            catch (JDOMException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            DataPolice.report(book, key, "Parse failed: " + ex.getMessage() + "\non: " + clean);
            ele = this.cleanTags(book, key, clean);
        }
        if (ele == null) {
            ele = OSISUtil.factory().createP();
        }
        return ele.removeContent();
    }

    @Override
    public OSISFilter clone() {
        OSISFilter clone;
        block2: {
            clone = null;
            try {
                clone = (OSISFilter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return clone;
    }

    private Element cleanTags(Book book, Key key, String plain) {
        String shawn = XMLUtil.cleanAllTags(plain);
        Throwable ex = null;
        try {
            return this.parse(shawn);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        DataPolice.report(book, key, "Parse failed: " + ex.getMessage() + "\non: " + shawn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element parse(String plain) throws JDOMException, IOException {
        Element div;
        SAXBuilder builder = (SAXBuilder)this.saxBuilders.poll();
        if (builder == null) {
            builder = new SAXBuilder();
        }
        StringReader in = null;
        try {
            in = new StringReader("<xxx>" + plain + "</xxx>");
            InputSource is = new InputSource(in);
            Document doc = builder.build(is);
            div = doc.getRootElement();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.saxBuilders.offer(builder);
        return div;
    }
}

