/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.internationalisation.LocaleProviderManager;

public final class Countries {
    public static final String DEFAULT_COUNTRY_CODE = "US";
    private static final String UNKNOWN_COUNTRY_CODE = "XX";

    private Countries() {
    }

    public static boolean isValidCountry(String iso3166Code) {
        String lookup = iso3166Code;
        if (lookup == null || lookup.length() == 0) {
            return true;
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Countries.isValidCountry(locale[1]);
        }
        if (lookup.length() > 2) {
            return false;
        }
        try {
            Countries.getLocalisedCountries().getString(lookup);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getCountry(String iso3166Code) {
        String lookup = iso3166Code;
        if (lookup == null || lookup.length() == 0) {
            return Countries.getCountry(DEFAULT_COUNTRY_CODE);
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Countries.getCountry(locale[1]);
        }
        try {
            return Countries.getLocalisedCountries().getString(lookup);
        }
        catch (MissingResourceException e) {
            return Countries.getCountry(UNKNOWN_COUNTRY_CODE);
        }
    }

    private static ResourceBundle getLocalisedCountries() {
        return ResourceBundle.getBundle("iso3166", LocaleProviderManager.getLocale(), CWClassLoader.instance());
    }
}

