/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.diff.EditType;

public class DifferenceEngine {
    private static final float TIMEOUT = 1.0f;
    private static float timeout = 1.0f;
    private final String source;
    private final String target;
    private final int targetLength;
    private final int sourceLength;

    public DifferenceEngine() {
        this("", "");
    }

    public DifferenceEngine(String source, String target) {
        this.source = source;
        this.target = target;
        this.sourceLength = source.length();
        this.targetLength = target.length();
    }

    public List<Difference> generate() {
        long msEnd = System.currentTimeMillis() + (long)(timeout * 1000.0f);
        int maxD = (this.sourceLength + this.targetLength) / 2;
        List<Set<String>> vMap1 = new ArrayList<Set<String>>();
        ArrayList<Set<String>> vMap2 = new ArrayList();
        HashMap<Integer, Integer> v1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> v2 = new HashMap<Integer, Integer>();
        v1.put(1, 0);
        v2.put(1, 0);
        HashMap<String, Integer> footsteps = new HashMap<String, Integer>();
        boolean done = false;
        boolean front = (this.sourceLength + this.targetLength) % 2 != 0;
        for (int d = 0; d < maxD; ++d) {
            Set s;
            String footstep;
            int y;
            int x;
            Integer kMinus1Value;
            Integer kMinus1Key;
            Integer kPlus1Value;
            Integer kPlus1Key;
            int k;
            if (timeout > 0.0f && System.currentTimeMillis() > msEnd) {
                return null;
            }
            vMap1.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                kPlus1Key = k + 1;
                kPlus1Value = (Integer)v1.get(kPlus1Key);
                kMinus1Key = k - 1;
                kMinus1Value = (Integer)v1.get(kMinus1Key);
                x = k == -d || k != d && kMinus1Value < kPlus1Value ? kPlus1Value : kMinus1Value + 1;
                y = x - k;
                footstep = x + "," + y;
                if (front && footsteps.containsKey(footstep)) {
                    done = true;
                }
                if (!front) {
                    footsteps.put(footstep, d);
                }
                while (!done && x < this.sourceLength && y < this.targetLength && this.source.charAt(x) == this.target.charAt(y)) {
                    footstep = ++x + "," + ++y;
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (front) continue;
                    footsteps.put(footstep, d);
                }
                v1.put(k, x);
                s = (Set)vMap1.get(d);
                s.add(x + "," + y);
                if (!done) continue;
                Integer footstepValue = (Integer)footsteps.get(footstep);
                vMap2 = vMap2.subList(0, footstepValue + 1);
                List<Difference> a = this.path1(vMap1, this.source.substring(0, x), this.target.substring(0, y));
                a.addAll(this.path2(vMap2, this.source.substring(x), this.target.substring(y)));
                return a;
            }
            vMap2.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                kPlus1Key = k + 1;
                kPlus1Value = (Integer)v2.get(kPlus1Key);
                kMinus1Key = k - 1;
                kMinus1Value = (Integer)v2.get(kMinus1Key);
                x = k == -d || k != d && kMinus1Value < kPlus1Value ? kPlus1Value : kMinus1Value + 1;
                y = x - k;
                footstep = this.sourceLength - x + "," + (this.targetLength - y);
                if (!front && footsteps.containsKey(footstep)) {
                    done = true;
                }
                if (front) {
                    footsteps.put(footstep, d);
                }
                while (!done && x < this.sourceLength && y < this.targetLength && this.source.charAt(this.sourceLength - x - 1) == this.target.charAt(this.targetLength - y - 1)) {
                    footstep = this.sourceLength - ++x + "," + (this.targetLength - ++y);
                    if (!front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) continue;
                    footsteps.put(footstep, d);
                }
                v2.put(k, x);
                s = (Set)vMap2.get(d);
                s.add(x + "," + y);
                if (!done) continue;
                Integer footstepValue = (Integer)footsteps.get(footstep);
                vMap1 = vMap1.subList(0, footstepValue + 1);
                List<Difference> a = this.path1(vMap1, this.source.substring(0, this.sourceLength - x), this.target.substring(0, this.targetLength - y));
                a.addAll(this.path2(vMap2, this.source.substring(this.sourceLength - x), this.target.substring(this.targetLength - y)));
                return a;
            }
        }
        return null;
    }

    protected List<Difference> path1(List<Set<String>> vMap, String newSource, String newTarget) {
        ArrayList<Difference> path = new ArrayList<Difference>();
        int x = newSource.length();
        int y = newTarget.length();
        EditType lastEditType = null;
        block0: for (int d = vMap.size() - 2; d >= 0; --d) {
            while (true) {
                Difference firstDiff;
                Set<String> set;
                if ((set = vMap.get(d)).contains(x - 1 + "," + y)) {
                    --x;
                    if (EditType.DELETE.equals((Object)lastEditType)) {
                        firstDiff = (Difference)path.get(0);
                        firstDiff.prependText(newSource.charAt(x));
                    } else {
                        path.add(0, new Difference(EditType.DELETE, newSource.substring(x, x + 1)));
                    }
                    lastEditType = EditType.DELETE;
                    continue block0;
                }
                if (set.contains(x + "," + (y - 1))) {
                    --y;
                    if (EditType.INSERT.equals((Object)lastEditType)) {
                        firstDiff = (Difference)path.get(0);
                        firstDiff.prependText(newTarget.charAt(y));
                    } else {
                        path.add(0, new Difference(EditType.INSERT, newTarget.substring(y, y + 1)));
                    }
                    lastEditType = EditType.INSERT;
                    continue block0;
                }
                assert (newSource.charAt(--x) == newTarget.charAt(--y)) : "No diagonal.  Can't happen. (path1)";
                if (EditType.EQUAL.equals((Object)lastEditType)) {
                    firstDiff = (Difference)path.get(0);
                    firstDiff.prependText(newSource.charAt(x));
                } else {
                    path.add(0, new Difference(EditType.EQUAL, newSource.substring(x, x + 1)));
                }
                lastEditType = EditType.EQUAL;
            }
        }
        return path;
    }

    protected List<Difference> path2(List<Set<String>> vMap, String newSource, String newTarget) {
        ArrayList<Difference> path = new ArrayList<Difference>();
        int cachedNewSourceLength = newSource.length();
        int cachedNewTargetLength = newTarget.length();
        int x = cachedNewSourceLength;
        int y = cachedNewTargetLength;
        EditType lastEditType = null;
        block0: for (int d = vMap.size() - 2; d >= 0; --d) {
            while (true) {
                Difference lastDiff;
                Set<String> set;
                if ((set = vMap.get(d)).contains(x - 1 + "," + y)) {
                    --x;
                    if (EditType.DELETE.equals((Object)lastEditType)) {
                        lastDiff = (Difference)path.get(path.size() - 1);
                        lastDiff.appendText(newSource.charAt(cachedNewSourceLength - x - 1));
                    } else {
                        path.add(new Difference(EditType.DELETE, newSource.substring(cachedNewSourceLength - x - 1, cachedNewSourceLength - x)));
                    }
                    lastEditType = EditType.DELETE;
                    continue block0;
                }
                if (set.contains(x + "," + (y - 1))) {
                    --y;
                    if (EditType.INSERT.equals((Object)lastEditType)) {
                        lastDiff = (Difference)path.get(path.size() - 1);
                        lastDiff.appendText(newTarget.charAt(cachedNewTargetLength - y - 1));
                    } else {
                        path.add(new Difference(EditType.INSERT, newTarget.substring(cachedNewTargetLength - y - 1, cachedNewTargetLength - y)));
                    }
                    lastEditType = EditType.INSERT;
                    continue block0;
                }
                assert (newSource.charAt(cachedNewSourceLength - --x - 1) == newTarget.charAt(cachedNewTargetLength - --y - 1)) : "No diagonal.  Can't happen. (path2)";
                if (EditType.EQUAL.equals((Object)lastEditType)) {
                    lastDiff = (Difference)path.get(path.size() - 1);
                    lastDiff.appendText(newSource.charAt(cachedNewSourceLength - x - 1));
                } else {
                    path.add(new Difference(EditType.EQUAL, newSource.substring(cachedNewSourceLength - x - 1, cachedNewSourceLength - x)));
                }
                lastEditType = EditType.EQUAL;
            }
        }
        return path;
    }

    public static void setTimeout(float newTimeout) {
        timeout = newTimeout;
    }
}

