/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.compress;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.crosswire.common.compress.AbstractCompressor;

public class BZip2
extends AbstractCompressor {
    public BZip2(InputStream input) {
        super(input);
    }

    @Override
    public ByteArrayOutputStream compress() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BZip2CompressorOutputStream out = new BZip2CompressorOutputStream((OutputStream)bos);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.flush();
        out.close();
        return bos;
    }

    @Override
    public ByteArrayOutputStream uncompress() throws IOException {
        return this.uncompress(2048);
    }

    @Override
    public ByteArrayOutputStream uncompress(int expectedLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(expectedLength);
        BZip2CompressorInputStream in = new BZip2CompressorInputStream(this.input);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.flush();
        out.close();
        return out;
    }
}

