/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.util.Convert;

public class BooleanField
extends JPanel
implements Field {
    private JRadioButton on;
    private JRadioButton off;
    private static final long serialVersionUID = 3617291237934053686L;

    public BooleanField() {
        ActionFactory actions = new ActionFactory(this);
        this.on = new JRadioButton(actions.addAction("Yes", BDMsg.gettext("Yes", new Object[0])));
        this.off = new JRadioButton(actions.addAction("No", BDMsg.gettext("No", new Object[0])));
        ButtonGroup group = new ButtonGroup();
        group.add(this.on);
        group.add(this.off);
        this.setLayout(new FlowLayout(3, 0, 0));
        this.add(this.on);
        this.add(this.off);
    }

    @Override
    public void setChoice(Choice param) {
    }

    @Override
    public String getValue() {
        return Convert.boolean2String((boolean)this.on.isSelected());
    }

    @Override
    public void setValue(String value) {
        this.on.setSelected(Convert.string2Boolean((String)value));
        this.off.setSelected(!Convert.string2Boolean((String)value));
    }

    public void doYes() {
        this.on.setSelected(true);
    }

    public void doNo() {
        this.off.setSelected(true);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

