/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.BookFont;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.util.ConfigurableSwingConverter;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.FormatType;
import org.crosswire.common.xml.PrettySerializingContentHandler;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ViewSourcePane
extends JPanel {
    private JTabbedPane tabMain;
    private JTextComponent[] textAreas;
    private JPanel pnlButtons;
    private JDialog frame;
    private transient ActionFactory actions;
    private static Converter converter = ConverterFactory.getConverter();
    private static final long serialVersionUID = 3257281435579985975L;

    public ViewSourcePane(Book[] books, Key key) {
        try {
            StringBuilder buf = new StringBuilder();
            for (Key currentKey : key) {
                String osisID = currentKey.getOsisID();
                for (int i = 0; i < books.length; ++i) {
                    Book book = books[i];
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(book.getInitials());
                    buf.append(':');
                    buf.append(osisID);
                    buf.append(" - ");
                    buf.append(book.getRawText(currentKey));
                }
            }
            BookData bdata = new BookData(books, key, false);
            Book book = bdata.getFirstBook();
            BookMetaData bmd = book.getBookMetaData();
            String fontSpec = GuiConvert.font2String(BookFont.instance().getFont(book));
            SAXEventProvider osissep = bdata.getSAXEventProvider();
            PrettySerializingContentHandler osis = new PrettySerializingContentHandler(FormatType.CLASSIC_INDENT);
            osissep.provideSAXEvents((ContentHandler)osis);
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)converter.convert(osissep);
            XSLTProperty.DIRECTION.setState(bmd.isLeftToRight() ? "ltr" : "rtl");
            URI loc = bmd.getLocation();
            XSLTProperty.BASE_URL.setState(loc == null ? "" : loc.getPath());
            if (bmd.getBookCategory() == BookCategory.BIBLE) {
                XSLTProperty.setProperties(htmlsep);
            } else {
                XSLTProperty.CSS.setProperty(htmlsep);
                XSLTProperty.BASE_URL.setProperty(htmlsep);
                XSLTProperty.DIRECTION.setProperty(htmlsep);
            }
            htmlsep.setParameter(XSLTProperty.FONT.getName(), (Object)fontSpec);
            PrettySerializingContentHandler html = new PrettySerializingContentHandler(FormatType.CLASSIC_INDENT);
            htmlsep.provideSAXEvents((ContentHandler)html);
            this.init(buf.toString(), osis.toString(), html.toString());
        }
        catch (SAXException e) {
            Reporter.informUser(null, (Throwable)e);
        }
        catch (TransformerException e) {
            Reporter.informUser(null, (Throwable)e);
        }
        catch (BookException e) {
            Reporter.informUser(null, (LucidException)e);
        }
    }

    private void init(String orig, String osis, String html) {
        this.actions = new ActionFactory(this);
        Font userRequestedFont = ConfigurableSwingConverter.toFont();
        JTextArea txtOrig = new JTextArea(orig, 24, 80);
        txtOrig.setFont(userRequestedFont);
        txtOrig.setLineWrap(true);
        txtOrig.setWrapStyleWord(true);
        txtOrig.setTabSize(2);
        txtOrig.setEditable(false);
        JPanel pnlOrig = new JPanel(new BorderLayout());
        pnlOrig.add((Component)new CWScrollPane(txtOrig), "Center");
        pnlOrig.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea txtOsis = new JTextArea(osis, 24, 80);
        txtOsis.setFont(userRequestedFont);
        txtOsis.setLineWrap(true);
        txtOsis.setWrapStyleWord(true);
        txtOsis.setTabSize(2);
        txtOsis.setEditable(false);
        JPanel pnlOsis = new JPanel(new BorderLayout());
        pnlOsis.add((Component)new CWScrollPane(txtOsis), "Center");
        pnlOsis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea txtHtml = new JTextArea(html, 24, 80);
        txtHtml.setFont(userRequestedFont);
        txtHtml.setLineWrap(true);
        txtHtml.setWrapStyleWord(true);
        txtHtml.setTabSize(2);
        txtHtml.setEditable(false);
        JPanel pnlHtml = new JPanel(new BorderLayout());
        pnlHtml.add((Component)new CWScrollPane(txtHtml), "Center");
        pnlHtml.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textAreas = new JTextComponent[]{txtOrig, txtOsis, txtHtml};
        this.pnlButtons = new JPanel(new FlowLayout(4));
        this.pnlButtons.add((Component)new JButton(this.actions.addAction("SourceClip", BDMsg.gettext("Copy", new Object[0])).setTooltip(BDMsg.gettext("Copy the source to the clipboard.", new Object[0]))), null);
        this.tabMain = new JTabbedPane();
        this.tabMain.add((Component)pnlOrig, BDMsg.gettext("Original", new Object[0]));
        this.tabMain.add((Component)pnlOsis, BDMsg.gettext("OSIS", new Object[0]));
        this.tabMain.add((Component)pnlHtml, BDMsg.gettext("HTML", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabMain, "Center");
        this.add((Component)this.pnlButtons, "South");
        GuiUtil.applyDefaultOrientation(this);
    }

    public void showInFrame(Frame parent) {
        this.frame = new JDialog(parent, BDMsg.gettext("Source Viewer", new Object[0]));
        CWAction action = this.actions.addAction("SourceOK", BDMsg.gettext("OK", new Object[0]));
        action.setTooltip(BDMsg.gettext("Close this window", new Object[0]));
        this.pnlButtons.add((Component)new JButton(action), null);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        GuiUtil.setSize((Window)this.frame, new Dimension(750, 500));
        GuiUtil.centerOnScreen(this.frame);
        this.frame.setVisible(true);
    }

    public void doSourceClip() {
        int i = this.tabMain.getSelectedIndex();
        JTextComponent tc = this.textAreas[i];
        StringSelection ss = new StringSelection(tc.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void doSourceOK() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }
}

