/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.EditSitePane;
import org.crosswire.bibledesktop.book.install.SitePane;
import org.crosswire.common.progress.swing.JobsProgressBar;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.LayoutPersistence;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerEvent;
import org.crosswire.jsword.book.install.InstallerListener;

public class SitesPane
extends JPanel {
    private transient Map<String, Installer> installers;
    protected transient InstallManager imanager;
    private transient ActionFactory actions;
    private JDialog dlgMain;
    private JPanel pnlButtons;
    protected JTabbedPane tabMain;
    private static final long serialVersionUID = 3258126947069605936L;

    public SitesPane() {
        this.init();
        this.imanager = new InstallManager();
        this.installers = this.imanager.getInstallers();
        this.addAllInstallers();
        this.imanager.addInstallerListener((InstallerListener)new SiteInstallerListener());
        GuiUtil.applyDefaultOrientation(this);
    }

    private void init() {
        this.actions = new ActionFactory(this);
        this.tabMain = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.tabMain, "Center");
        this.add((Component)new JobsProgressBar(true), "South");
    }

    protected final void addAllInstallers() {
        for (String name : this.installers.keySet()) {
            Installer installer = this.installers.get(name);
            SitePane site = new SitePane(installer);
            this.tabMain.add(name, site);
        }
        this.tabMain.add(BDMsg.gettext("Installed Books", new Object[0]), new SitePane());
    }

    protected void removeAllInstallers() {
        this.tabMain.removeAll();
    }

    public void doManageSites() {
        EditSitePane edit = new EditSitePane(this.imanager);
        edit.showInDialog(this);
    }

    public void doSitesClose() {
        if (this.dlgMain != null) {
            LayoutPersistence.instance().saveLayout(this.dlgMain);
            this.dlgMain.setVisible(false);
        }
    }

    public void showInDialog(Component parent) {
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getContentPane().add(this.createButtons(), "South");
        this.dlgMain.setTitle(BDMsg.gettext("Available Books", new Object[0]));
        this.dlgMain.setResizable(true);
        this.dlgMain.setName("Sites");
        this.dlgMain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                SitesPane.this.doSitesClose();
            }
        });
        this.dlgMain.setLocationRelativeTo(parent);
        LayoutPersistence layoutPersistence = LayoutPersistence.instance();
        if (layoutPersistence.isLayoutPersisted(this.dlgMain)) {
            layoutPersistence.restoreLayout(this.dlgMain);
        } else {
            this.dlgMain.setSize(750, 500);
            GuiUtil.centerOnScreen(this.dlgMain);
        }
        this.dlgMain.setVisible(true);
        this.dlgMain.toFront();
        GuiUtil.applyDefaultOrientation(this.dlgMain);
    }

    private Component createButtons() {
        if (this.pnlButtons == null) {
            JButton btnOK = new JButton(this.actions.addAction("SitesClose", BDMsg.gettext("OK", new Object[0])));
            JButton btnAdd = new JButton(this.actions.addAction("ManageSites", BDMsg.gettext("Edit Sites ...", new Object[0])));
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new FlowLayout(4));
            this.pnlButtons.add((Component)btnAdd, null);
            this.pnlButtons.add(btnOK);
        }
        return this.pnlButtons;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(this);
        this.imanager = new InstallManager();
        this.installers = this.imanager.getInstallers();
        is.defaultReadObject();
        this.addAllInstallers();
        this.imanager.addInstallerListener((InstallerListener)new SiteInstallerListener());
    }

    class SiteInstallerListener
    implements InstallerListener {
        SiteInstallerListener() {
        }

        public void installerAdded(InstallerEvent ev) {
            Installer installer = ev.getInstaller();
            String name = SitesPane.this.imanager.getInstallerNameForInstaller(installer);
            SitePane site = new SitePane(installer);
            SitesPane.this.tabMain.add(name, site);
        }

        public void installerRemoved(InstallerEvent ev) {
            SitesPane.this.removeAllInstallers();
            SitesPane.this.addAllInstallers();
        }
    }
}

