/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class MetalPanelBorder
extends AbstractBorder
implements UIResource {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    private int insetTop = 1;
    private int insetLeft = 1;
    private int insetBottom = 2;
    private int insetRight = 2;
    private int flags;
    private Insets insets;
    private static final long serialVersionUID = 7929433986066846750L;

    public MetalPanelBorder() {
        this.insets = new Insets(this.insetTop, this.insetLeft, this.insetBottom, this.insetRight);
    }

    public MetalPanelBorder(int borderFlags) {
        this.flags = 0 | borderFlags;
        if ((this.flags & 1) != 1) {
            this.insetTop = 0;
        }
        if ((this.flags & 2) != 2) {
            this.insetLeft = 0;
        }
        if ((this.flags & 4) != 4) {
            this.insetBottom = 0;
        }
        if ((this.flags & 8) != 8) {
            this.insetRight = 0;
        }
        this.insets = new Insets(this.insetTop, this.insetLeft, this.insetBottom, this.insetRight);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        if ((this.flags & 1) == 1) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 2, 0);
        }
        if ((this.flags & 2) == 2) {
            g.drawLine(0, 0, 0, h - 2);
        }
        if ((this.flags & 4) == 4) {
            g.drawLine(0, h - 2, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, h - 1, w - 1, h - 1);
        }
        if ((this.flags & 8) == 8) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(w - 2, h - 2, w - 2, 0);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, h - 1, w - 1, 1);
        }
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }
}

