/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.BookFont;
import org.crosswire.bibledesktop.book.install.BookNode;
import org.crosswire.bibledesktop.book.install.BookTreeCellRenderer;
import org.crosswire.bibledesktop.book.install.IndexResolver;
import org.crosswire.bibledesktop.book.install.InternetWarning;
import org.crosswire.bibledesktop.book.install.TextPaneBookMetaDataDisplay;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.FontChooser;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.util.WebWarning;

public class SitePane
extends JPanel {
    protected transient Installer installer;
    private transient ActionFactory actions;
    private JTree treAvailable;
    private transient TextPaneBookMetaDataDisplay display;
    private JLabel lblDesc;
    private static final long serialVersionUID = 3616445692051075634L;

    public SitePane() {
        this(null, BDMsg.gettext("Installed Books:", new Object[0]));
    }

    public SitePane(Installer bookListInstaller) {
        this(bookListInstaller, BDMsg.gettext("Available Books:", new Object[0]));
    }

    private SitePane(Installer bookListInstaller, String labelAcronymn) {
        this.installer = bookListInstaller;
        this.actions = new ActionFactory(this);
        Installer bl = this.installer;
        if (bl == null) {
            bl = Books.installed();
            bl.addBooksListener((BooksListener)new CustomBooksListener());
        }
        this.initialize(labelAcronymn, (BookList)bl);
    }

    private void initialize(String labelAcronymn, BookList books) {
        this.lblDesc = new JLabel();
        this.lblDesc.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        Component left = this.createAvailablePanel(labelAcronymn, books);
        Component right = this.createSelectedPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblDesc, "North");
        this.add(this.createSplitPane(left, right), "Center");
        this.updateDescription();
    }

    private void updateDescription() {
        String desc = "#ERROR#";
        if (this.installer == null) {
            int bookCount = Books.installed().getBooks().size();
            desc = BDMsg.gettext("{0} books installed.", bookCount);
        } else {
            int bookCount = this.installer.getBooks().size();
            if (bookCount == 0) {
                StringBuilder buf = new StringBuilder(200);
                buf.append("<html><b>");
                buf.append(BDMsg.gettext("Click 'Update Available Books' to download an up to date book list.", new Object[0]));
                buf.append("</b>");
                desc = buf.toString();
            } else {
                desc = BDMsg.gettext("{0} books available for download.", bookCount);
            }
        }
        this.lblDesc.setText(desc);
    }

    private Component createSplitPane(Component left, Component right) {
        FixedSplitPane split = new FixedSplitPane();
        ((JSplitPane)split).setDividerLocation(0.3);
        split.setResizeWeight(0.3);
        split.setOrientation(1);
        split.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        split.setDividerSize(10);
        ((JSplitPane)split).setLeftComponent(left);
        ((JSplitPane)split).setRightComponent(right);
        return split;
    }

    private Component createAvailablePanel(String labelAcronymn, BookList books) {
        JLabel lblAvailable = CWLabel.createJLabel(labelAcronymn);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblAvailable, "First");
        panel.add(this.createScrolledTree(books), "Center");
        panel.add(this.createPanelActions(), "Last");
        lblAvailable.setLabelFor(this.treAvailable);
        return panel;
    }

    private Component createSelectedPanel() {
        JLabel lblSelected = CWLabel.createJLabel(BDMsg.gettext("Selected Book:", new Object[0]));
        this.display = new TextPaneBookMetaDataDisplay();
        lblSelected.setLabelFor(this.display.getComponent());
        CWScrollPane scrSelected = new CWScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblSelected, "First");
        panel.add((Component)scrSelected, "Center");
        scrSelected.getViewport().add(this.display.getComponent());
        return panel;
    }

    private Component createScrolledTree(BookList books) {
        this.treAvailable = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this.treAvailable);
        this.treAvailable.setCellRenderer(new BookTreeCellRenderer());
        this.setTreeModel(books);
        this.treAvailable.putClientProperty("JTree.lineStyle", "Angled");
        this.treAvailable.getSelectionModel().setSelectionMode(1);
        this.treAvailable.setCellEditor(null);
        this.treAvailable.setRootVisible(false);
        this.treAvailable.setShowsRootHandles(true);
        this.treAvailable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                SitePane.this.selected();
            }
        });
        return new CWScrollPane(this.treAvailable);
    }

    private TreeModel createTreeModel(BookList books) {
        BookSet bmds = new BookSet((Collection)books.getBooks());
        BookNode bookRoot = new BookNode("root", bmds, 0, "Category", "Language");
        return new DefaultTreeModel(bookRoot);
    }

    private Book getBook(Object anObj) {
        Object obj = anObj;
        if (obj instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof Book) {
            return (Book)obj;
        }
        return null;
    }

    private Language getLanguage(Object anObj) {
        Object obj = anObj;
        if (obj instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof Language) {
            return (Language)obj;
        }
        return null;
    }

    private Component createPanelActions() {
        JPanel panel = new JPanel();
        if (this.installer != null) {
            panel.setLayout(new GridLayout(1, 2, 3, 3));
            CWAction action = this.actions.addAction("Install", BDMsg.gettext("Install", new Object[0]));
            action.setTooltip(BDMsg.gettext("Install the selected book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
            action = this.actions.addAction("Refresh", BDMsg.gettext("Update Available Books", new Object[0]));
            action.setTooltip(BDMsg.gettext("Download a current listing of books.", new Object[0]));
            panel.add(new JButton(action));
        } else {
            panel.setLayout(new GridLayout(3, 2, 3, 3));
            CWAction action = this.actions.addAction("Delete", BDMsg.gettext("Delete Book", new Object[0]));
            action.setTooltip(BDMsg.gettext("Delete the selected book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
            action = this.actions.addAction("Unindex", BDMsg.gettext("Remove Search Index", new Object[0]));
            action.setTooltip(BDMsg.gettext("Remove the search index of the selected book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
            action = this.actions.addAction("ChooseFont", BDMsg.gettext("Font...", new Object[0]));
            action.setTooltip(BDMsg.gettext("Choose a font for the language or book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
            action = this.actions.addAction("Unlock", BDMsg.gettext("Unlock", new Object[0]));
            action.setTooltip(BDMsg.gettext("Unlock the selected book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
            action = this.actions.addAction("ResetFont", BDMsg.gettext("Reset Font", new Object[0]));
            action.setTooltip(BDMsg.gettext("Reset the custom font set for this language or book", new Object[0]));
            action.enable(false);
            panel.add(new JButton(action));
        }
        return panel;
    }

    public void doDelete() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        try {
            String msg = BDMsg.gettext("Are you sure you want to delete {0}?", book.getName());
            if (CWOptionPane.showConfirmDialog(this, msg, BDMsg.gettext("Delete Book", new Object[0]), 0) == 0) {
                book.getDriver().delete(book);
                IndexManager imanager = IndexManagerFactory.getIndexManager();
                if (imanager.isIndexed(book)) {
                    imanager.deleteIndex(book);
                }
            }
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void doUnlock() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        String title = BDMsg.gettext("Unlock Book", new Object[0]);
        StringBuilder msg = new StringBuilder(200);
        msg.append(BDMsg.gettext("Please enter the unlock key for:", new Object[0]));
        msg.append('\n');
        msg.append(book.getName());
        String unlockKey = (String)CWOptionPane.showInputDialog(this, msg.toString(), title, 3, null, null, book.getUnlockKey());
        if (unlockKey != null && unlockKey.length() > 0) {
            book.unlock(unlockKey);
            Books.installed().addBook(book);
        }
    }

    public void doUnindex() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        try {
            String formattedMsg;
            IndexManager imanager = IndexManagerFactory.getIndexManager();
            if (imanager.isIndexed(book) && CWOptionPane.showConfirmDialog(this, formattedMsg = BDMsg.gettext("Are you sure you want to remove the index for {0}?", book.getName()), BDMsg.gettext("Remove Index for Book", new Object[0]), 0) == 0) {
                imanager.deleteIndex(book);
            }
            this.actions.findAction("Unindex").setEnabled(imanager.isIndexed(book));
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void doRefresh() {
        if (this.installer != null) {
            try {
                int webAccess = 0;
                if (WebWarning.instance().isShown()) {
                    webAccess = InternetWarning.showDialog(this, "?");
                }
                if (webAccess == 0) {
                    this.installer.reloadBookList();
                    this.setTreeModel((BookList)this.installer);
                }
            }
            catch (InstallException ex) {
                Reporter.informUser((Object)this, (LucidException)ex);
            }
        }
    }

    public void doInstall() {
        if (this.installer == null) {
            return;
        }
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        int webAccess = 0;
        if (WebWarning.instance().isShown()) {
            webAccess = InternetWarning.showDialog(this, "?");
        }
        if (webAccess != 0) {
            return;
        }
        Object last = path.getLastPathComponent();
        final Book name = this.getBook(last);
        Book book = Books.installed().getBook(name.getInitials());
        if (book != null && !this.installer.isNewer(name)) {
            Reporter.informUser((Object)this, (String)BDMsg.gettext("Book already installed: {0}", name.getName()));
            return;
        }
        float size = (float)this.installer.getSize(name) / 1024.0f;
        String formattedMsg = "";
        formattedMsg = size > 1024.0f ? BDMsg.gettext("{0} is {1,number,###,###,###.#}MB. Continue?", name.getName(), Float.valueOf(size /= 1024.0f)) : BDMsg.gettext("{0} is {1,number,###,###,###.#}KB. Continue?", name.getName(), Float.valueOf(size));
        if (CWOptionPane.showConfirmDialog(this, formattedMsg, BDMsg.gettext("Download Book", new Object[0]), 0) == 0) {
            final SitePane pane = this;
            Thread worker = new Thread("BookDownloader"){

                @Override
                public void run() {
                    try {
                        SitePane.this.installer.install(name);
                    }
                    catch (InstallException ex) {
                        Reporter.informUser((Object)pane, (LucidException)ex);
                    }
                }
            };
            worker.setPriority(1);
            worker.start();
        }
    }

    public void doInstallSearch() {
        this.doInstall();
        TreePath path = this.treAvailable.getSelectionPath();
        if (path != null) {
            Object last = path.getLastPathComponent();
            Book book = this.getBook(last);
            IndexResolver.scheduleIndex(book, this);
        }
    }

    public void doChooseFont() {
        Language language;
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        if (book != null) {
            Font picked = FontChooser.showDialog(this, BDMsg.gettext("Choose Font", new Object[0]), BookFont.instance().getFont(book));
            BookFont.instance().setFont(book, picked);
        }
        if ((language = this.getLanguage(last)) != null) {
            Font picked = FontChooser.showDialog(this, BDMsg.gettext("Choose Font", new Object[0]), BookFont.instance().getFont(language));
            BookFont.instance().setFont(language, picked);
        }
        this.actions.findAction("ResetFont").setEnabled(BookFont.instance().isSet(book, language));
    }

    public void doResetFont() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        Language language = this.getLanguage(last);
        BookFont.instance().resetFont(book, language);
        this.actions.findAction("ResetFont").setEnabled(false);
    }

    protected void selected() {
        TreePath path = this.treAvailable.getSelectionPath();
        Book book = null;
        Language lang = null;
        if (path != null) {
            Object last = path.getLastPathComponent();
            book = this.getBook(last);
            lang = this.getLanguage(last);
        }
        this.display.setBook(book);
        this.actions.findAction("Delete").setEnabled(book != null && book.getDriver().isDeletable(book));
        this.actions.findAction("Unlock").setEnabled(book != null && book.isEnciphered());
        this.actions.findAction("Unindex").setEnabled(book != null && IndexManagerFactory.getIndexManager().isIndexed(book));
        this.actions.findAction("Install").setEnabled(book != null && book.isSupported());
        this.actions.findAction("InstallSearch").setEnabled(book != null && book.isSupported() && book.getBookCategory() == BookCategory.BIBLE);
        this.actions.findAction("ChooseFont").setEnabled(book != null || lang != null);
        this.actions.findAction("ResetFont").setEnabled(BookFont.instance().isSet(book, lang));
    }

    public void setTreeModel(BookList books) {
        this.treAvailable.setModel(this.createTreeModel(books));
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.installer = null;
        this.display = null;
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }

    final class CustomBooksListener
    implements BooksListener {
        CustomBooksListener() {
        }

        public void bookAdded(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }

        public void bookRemoved(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }
    }
}

