/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.jsword.versification.BibleBook;

class BibleBookList
implements Iterable<BibleBook>,
Serializable {
    protected BibleBook[] books;
    private int[] bookMap;
    private static final long serialVersionUID = -2681289798451902815L;

    public BibleBookList(BibleBook[] books) {
        this.books = (BibleBook[])books.clone();
        this.initialize();
    }

    public boolean contains(BibleBook book) {
        return book != null && this.bookMap[book.ordinal()] != -1;
    }

    public int getOrdinal(BibleBook book) {
        return this.bookMap[book.ordinal()];
    }

    public int getBookCount() {
        return this.books.length;
    }

    public BibleBook getBook(int ordinal) {
        int ord = ordinal;
        if (ord < 0) {
            ord = 0;
        }
        if (ord >= this.books.length) {
            ord = this.books.length - 1;
        }
        return this.books[ord];
    }

    @Override
    public Iterator<BibleBook> iterator() {
        return new Iterator<BibleBook>(){
            private BibleBook nextBook;
            {
                this.nextBook = BibleBookList.this.books[0];
            }

            @Override
            public boolean hasNext() {
                return this.nextBook != null;
            }

            @Override
            public BibleBook next() {
                if (this.nextBook == null) {
                    throw new NoSuchElementException();
                }
                BibleBook current = this.nextBook;
                this.nextBook = BibleBookList.this.getNextBook(this.nextBook);
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BibleBook getFirstBook() {
        return this.books[0];
    }

    public BibleBook getLastBook() {
        return this.books[this.books.length - 1];
    }

    public BibleBook getPreviousBook(BibleBook book) {
        int ordinal = book.ordinal();
        int position = this.bookMap[ordinal];
        if (position > 0) {
            return this.books[position - 1];
        }
        return null;
    }

    public BibleBook getNextBook(BibleBook book) {
        int ordinal = book.ordinal();
        int position = this.bookMap[ordinal];
        if (position != -1 && position + 1 < this.books.length) {
            return this.books[position + 1];
        }
        return null;
    }

    private void initialize() {
        this.bookMap = new int[BibleBook.values().length + 1];
        for (BibleBook b : BibleBook.values()) {
            this.bookMap[b.ordinal()] = -1;
        }
        for (int i = 0; i < this.books.length; ++i) {
            this.bookMap[this.books[i].ordinal()] = i;
        }
    }
}

