/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.jsword.passage.AbstractKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyIterator;
import org.crosswire.jsword.passage.RestrictionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeKey
extends AbstractKeyList {
    private Key parent;
    private List<Key> children;
    private static final Logger log = LoggerFactory.getLogger(TreeKey.class);
    private static final long serialVersionUID = -6560408145705717977L;

    public TreeKey(String name, Key parent) {
        super(name);
        this.parent = parent;
        this.children = new ArrayList<Key>();
    }

    public TreeKey(String text) {
        this(text, null);
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getCardinality() {
        int cardinality = 1;
        for (Key child : this.children) {
            cardinality += child.getCardinality();
        }
        return cardinality;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(Key key) {
        if (this.children.contains(key)) {
            return true;
        }
        for (Key child : this.children) {
            if (!child.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Key> iterator() {
        return new KeyIterator(this);
    }

    @Override
    public void addAll(Key key) {
        this.children.add(key);
    }

    @Override
    public void removeAll(Key key) {
        this.children.remove(key);
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public Key get(int index) {
        return this.children.get(index);
    }

    @Override
    public int indexOf(Key that) {
        return this.children.indexOf(that);
    }

    @Override
    public Key getParent() {
        return this.parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TreeKey otherTreeKey = (TreeKey)obj;
        if (!this.getName().equals(otherTreeKey.getName())) {
            return false;
        }
        if (this.getParent() == null) {
            return otherTreeKey.getParent() == null;
        }
        return ((Object)this.getParent()).equals(otherTreeKey.getParent());
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
        log.warn("attempt to blur a non-blur-able list");
    }

    @Override
    public TreeKey clone() {
        return (TreeKey)super.clone();
    }

    @Override
    public String getRootName() {
        String rootName = this.getName();
        for (Key parentKey = this; parentKey != null && parentKey.getName().length() > 0; parentKey = parentKey.getParent()) {
            rootName = parentKey.getName();
        }
        return rootName;
    }

    @Override
    public String getOsisRef() {
        return this.getOsisID();
    }

    @Override
    public String getOsisID() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.osisify(this.getName()));
        for (Key parentKey = this.getParent(); parentKey != null && parentKey.getName().length() > 0; parentKey = parentKey.getParent()) {
            b.insert(0, ".");
            b.insert(0, this.osisify(parentKey.getName()));
        }
        return b.toString();
    }

    private String osisify(String str) {
        return str.replace(' ', '_');
    }
}

