/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.versification.BookName;

public class BookExporter {
    private Book book;

    public BookExporter(Book book) {
        this.book = book;
    }

    public void mod2imp() throws BookException {
        if (BookCategory.BIBLE.equals((Object)this.book.getBookCategory())) {
            BookName.setFullBookName(false);
        }
        Key keys = this.book.getGlobalKeyList();
        StringBuilder buf = new StringBuilder();
        for (Key key : keys) {
            String rawText = this.book.getRawText(key);
            if (rawText == null || rawText.trim().length() <= 0) continue;
            buf.delete(0, buf.length());
            buf.append("$$$").append(key).append('\n').append(rawText);
            System.out.println(buf.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            BookExporter.usage();
            return;
        }
        System.err.println("BookExporter " + args[0]);
        Book b = Books.installed().getBook(args[0]);
        if (b == null) {
            System.err.println("Book not found");
            return;
        }
        BookExporter exporter = new BookExporter(b);
        try {
            exporter.mod2imp();
        }
        catch (BookException e) {
            System.err.println("Error while exporting");
            e.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Usage: BookExporter book");
    }
}

