/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.crosswire.common.util.IniSection;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.book.MetaDataLocator;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterFactory;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.SwordMetaDataLocator;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwordBookMetaData
extends AbstractBookMetaData {
    public static final String KEY_ABBREVIATION = "Abbreviation";
    public static final String KEY_ABOUT = "About";
    public static final String KEY_BLOCK_COUNT = "BlockCount";
    public static final String KEY_BLOCK_TYPE = "BlockType";
    public static final String KEY_CIPHER_KEY = "CipherKey";
    public static final String KEY_COMPRESS_TYPE = "CompressType";
    public static final String KEY_COPYRIGHT = "Copyright";
    public static final String KEY_COPYRIGHT_CONTACT_ADDRESS = "CopyrightContactAddress";
    public static final String KEY_COPYRIGHT_CONTACT_EMAIL = "CopyrightContactEmail";
    public static final String KEY_COPYRIGHT_CONTACT_NAME = "CopyrightContactName";
    public static final String KEY_COPYRIGHT_CONTACT_NOTES = "CopyrightContactNotes";
    public static final String KEY_COPYRIGHT_DATE = "CopyrightDate";
    public static final String KEY_COPYRIGHT_HOLDER = "CopyrightHolder";
    public static final String KEY_COPYRIGHT_NOTES = "CopyrightNotes";
    public static final String KEY_DATA_PATH = "DataPath";
    public static final String KEY_DESCRIPTION = "Description";
    public static final String KEY_DIRECTION = "Direction";
    public static final String KEY_DISPLAY_LEVEL = "DisplayLevel";
    public static final String KEY_DISTRIBUTION_LICENSE = "DistributionLicense";
    public static final String KEY_DISTRIBUTION_NOTES = "DistributionNotes";
    public static final String KEY_DISTRIBUTION_SOURCE = "DistributionSource";
    public static final String KEY_ENCODING = "Encoding";
    public static final String KEY_FEATURE = "Feature";
    public static final String KEY_GLOBAL_OPTION_FILTER = "GlobalOptionFilter";
    public static final String KEY_GLOSSARY_FROM = "GlossaryFrom";
    public static final String KEY_GLOSSARY_TO = "GlossaryTo";
    public static final String KEY_HISTORY = "History";
    public static final String KEY_INSTALL_SIZE = "InstallSize";
    public static final String KEY_KEY_TYPE = "KeyType";
    public static final String KEY_LCSH = "LCSH";
    public static final String KEY_LOCAL_STRIP_FILTER = "LocalStripFilter";
    public static final String KEY_MINIMUM_VERSION = "MinimumVersion";
    public static final String KEY_MOD_DRV = "ModDrv";
    public static final String KEY_OBSOLETES = "Obsoletes";
    public static final String KEY_OSIS_Q_TO_TICK = "OSISqToTick";
    public static final String KEY_OSIS_VERSION = "OSISVersion";
    public static final String KEY_PREFERRED_CSS_XHTML = "PreferredCSSXHTML";
    public static final String KEY_SEARCH_OPTION = "SearchOption";
    public static final String KEY_SHORT_COPYRIGHT = "ShortCopyright";
    public static final String KEY_SHORT_PROMO = "ShortPromo";
    public static final String KEY_SOURCE_TYPE = "SourceType";
    public static final String KEY_STRONGS_PADDING = "StrongsPadding";
    public static final String KEY_SWORD_VERSION_DATE = "SwordVersionDate";
    public static final String KEY_TEXT_SOURCE = "TextSource";
    public static final String KEY_UNLOCK_URL = "UnlockURL";
    public static final String KEY_VERSION = "Version";
    public static final Map<String, String> DEFAULTS;
    private String bookConf;
    private IniSection configAll;
    private IniSection configSword;
    private IniSection configJSword;
    private IniSection configFrontend;
    private boolean supported = true;
    private BookCategory bookCat;
    private BookType bookType;
    private boolean questionable;
    private File configFile;
    private static final String[] OSIS_INFO;
    private static final String[] HIDDEN;
    private static final Pattern RTF_PATTERN;
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_LATIN1 = "WINDOWS-1252";
    private static final PropertyMap ENCODING_JAVA;
    private static final Logger log;

    public SwordBookMetaData(File file, URI bookRootPath) throws IOException, BookException {
        this.configFile = file;
        this.bookConf = file.getName();
        this.configSword = this.load(file);
        this.configAll = new IniSection(this.configSword);
        this.configJSword = this.addConfig(SwordMetaDataLocator.JSWORD);
        this.configFrontend = this.addConfig(SwordMetaDataLocator.FRONTEND);
        this.adjustConfig();
        this.report();
        this.setLibrary(bookRootPath);
    }

    public SwordBookMetaData(byte[] buffer, String bookConf) throws IOException {
        this.bookConf = bookConf;
        this.configSword = this.load(buffer);
        this.configAll = new IniSection(this.configSword);
        this.configJSword = new IniSection(this.configSword.getName());
        this.configFrontend = new IniSection(this.configSword.getName());
        this.adjustConfig();
        this.report();
    }

    @Override
    public boolean isQuestionable() {
        return this.questionable;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public boolean isEnciphered() {
        String cipher = this.getProperty(KEY_CIPHER_KEY);
        return cipher != null;
    }

    @Override
    public boolean isLocked() {
        String cipher = this.getProperty(KEY_CIPHER_KEY);
        return cipher != null && cipher.length() == 0;
    }

    @Override
    public boolean unlock(String unlockKey) {
        this.putProperty(KEY_CIPHER_KEY, unlockKey);
        return true;
    }

    @Override
    public String getUnlockKey() {
        return this.getProperty(KEY_CIPHER_KEY);
    }

    @Override
    public String getName() {
        return this.getProperty(KEY_DESCRIPTION);
    }

    public String getBookCharset() {
        return ENCODING_JAVA.get(this.getProperty(KEY_ENCODING));
    }

    @Override
    public KeyType getKeyType() {
        BookType bt = this.getBookType();
        if (bt == null) {
            return null;
        }
        return bt.getKeyType();
    }

    public BookType getBookType() {
        return this.bookType;
    }

    public Filter getFilter() {
        String sourcetype = this.getProperty(KEY_SOURCE_TYPE);
        return FilterFactory.getFilter(sourcetype);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setLibrary(URI library) throws BookException {
        URI location;
        File bookDir;
        if (!this.supported) {
            return;
        }
        super.setLibrary(library);
        String datapath = this.getProperty(KEY_DATA_PATH);
        int lastSlash = datapath.lastIndexOf(47);
        if (lastSlash == -1) {
            return;
        }
        boolean isDirectoryPath = false;
        if (lastSlash == datapath.length() - 1) {
            isDirectoryPath = true;
            datapath = datapath.substring(0, lastSlash);
        }
        if (!(bookDir = new File((location = NetUtil.lengthenURI(library, datapath)).getPath())).isDirectory()) {
            if (isDirectoryPath) {
                throw new BookException(JSMsg.gettext("The book {0} is missing its data files", this.configAll.getName()));
            }
            if (!new File(location.getPath() + ".dat").exists()) {
                throw new BookException(JSMsg.gettext("The book {0} is missing its data files", this.configAll.getName()));
            }
            lastSlash = datapath.lastIndexOf(47);
            datapath = datapath.substring(0, lastSlash);
            location = NetUtil.lengthenURI(library, datapath);
        }
        super.setLocation(location);
    }

    @Override
    public BookCategory getBookCategory() {
        if (this.bookCat == null) {
            this.bookCat = (BookCategory)((Object)this.getValue("Category"));
            if (this.bookCat == BookCategory.OTHER) {
                BookType bt = this.getBookType();
                if (bt == null) {
                    return null;
                }
                this.bookCat = bt.getBookCategory();
            }
        }
        return this.bookCat;
    }

    @Override
    public Document toOSIS() {
        ArrayList<String> knownKeys = new ArrayList<String>(this.configAll.getKeys());
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element table = factory.createTable();
        Element row = this.toRow(factory, "Initials", this.getInitials());
        table.addContent((Content)row);
        for (String key : OSIS_INFO) {
            knownKeys.remove(key);
            row = this.toRow(factory, key);
            if (row == null) continue;
            table.addContent((Content)row);
        }
        List<String> hide = Arrays.asList(HIDDEN);
        for (String key : knownKeys) {
            if (hide.contains(key) || (row = this.toRow(factory, key)) == null) continue;
            table.addContent((Content)row);
        }
        return new Document(table);
    }

    @Override
    public String getInitials() {
        String abbreviation = this.getProperty(KEY_ABBREVIATION);
        if (abbreviation != null && abbreviation.length() > 0) {
            return abbreviation;
        }
        return this.getInternalName();
    }

    @Override
    public String getInternalName() {
        String abbreviation = this.getProperty(KEY_ABBREVIATION);
        if (abbreviation != null && abbreviation.length() > 0) {
            return abbreviation;
        }
        return this.configAll.getName();
    }

    @Override
    public boolean isLeftToRight() {
        String dir = this.getProperty(KEY_DIRECTION);
        if ("bidi".equalsIgnoreCase(dir)) {
            Language lang = this.getLanguage();
            return lang.isLeftToRight();
        }
        return "LtoR".equalsIgnoreCase(dir);
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        String name = feature.toString();
        if (this.configAll.containsValue(KEY_FEATURE, name)) {
            return true;
        }
        StringBuilder buffer = new StringBuilder(this.getProperty(KEY_SOURCE_TYPE));
        buffer.append(name);
        if (this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, buffer.toString())) {
            return true;
        }
        String alias = feature.getAlias();
        buffer.setLength(0);
        buffer.append(this.getProperty(KEY_SOURCE_TYPE));
        buffer.append(alias);
        return this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, name) || this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, buffer.toString());
    }

    @Override
    public Set<String> getPropertyKeys() {
        return null;
    }

    @Override
    public String getProperty(String key) {
        if ("Language".equals(key)) {
            return this.getLanguage().getName();
        }
        return this.configAll.get(key, DEFAULTS.get(key));
    }

    @Override
    public void putProperty(String key, String value, boolean forFrontend) {
        SwordMetaDataLocator mdl = forFrontend ? SwordMetaDataLocator.FRONTEND : SwordMetaDataLocator.JSWORD;
        IniSection config = forFrontend ? this.configFrontend : this.configJSword;
        config.replace(key, value);
        this.configAll.replace(key, value);
        try {
            config.save(new File(mdl.getWriteLocation(), this.bookConf), this.getBookCharset());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private IniSection load(File file) throws IOException {
        IniSection config = new IniSection();
        this.configFile = file;
        config.load(file, ENCODING_UTF8);
        String encoding = config.get(KEY_ENCODING);
        if (!ENCODING_UTF8.equalsIgnoreCase(encoding)) {
            config.clear();
            config.load(file, ENCODING_LATIN1);
        }
        return config;
    }

    private IniSection load(byte[] buffer) throws IOException {
        IniSection config = new IniSection();
        config.load(buffer, ENCODING_UTF8);
        String encoding = config.get(KEY_ENCODING);
        if (!ENCODING_UTF8.equalsIgnoreCase(encoding)) {
            config.clear();
            config.load(buffer, ENCODING_LATIN1);
        }
        return config;
    }

    private IniSection addConfig(MetaDataLocator locator) {
        IniSection config = new IniSection();
        File conf = new File(locator.getWriteLocation(), this.bookConf);
        if (!conf.exists()) {
            conf = new File(locator.getReadLocation(), this.bookConf);
        }
        if (conf.exists()) {
            String encoding = this.getProperty(KEY_ENCODING);
            try {
                config.load(conf, encoding);
                this.mergeConfig(config);
            }
            catch (IOException e) {
                log.error("Unable to load conf {}:{}", (Object)conf, (Object)e);
            }
        }
        return config;
    }

    private void mergeConfig(IniSection config) {
        for (String key : config.getKeys()) {
            ConfigEntryType type = ConfigEntryType.fromString(key);
            for (String value : config.getValues(key)) {
                if (type != null && type.mayRepeat()) {
                    if (this.configAll.containsValue(key, value)) continue;
                    this.configAll.add(key, value);
                    continue;
                }
                this.configAll.replace(key, value);
            }
        }
    }

    private Object getValue(String key) {
        ConfigEntryType type = ConfigEntryType.fromString(key);
        String ce = this.getProperty(key);
        if (type == null) {
            return ce;
        }
        return ce == null ? null : type.convert(ce);
    }

    private Element toRow(OSISUtil.OSISFactory factory, String key, String value) {
        Element nameEle = this.toKeyCell(factory, key);
        Element valueElement = factory.createCell();
        valueElement.addContent(value);
        Element rowEle = factory.createRow();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        return rowEle;
    }

    private Element toRow(OSISUtil.OSISFactory factory, String key) {
        int size = this.configAll.size(key);
        if (size == 0) {
            return null;
        }
        ConfigEntryType type = ConfigEntryType.fromString(key);
        Element nameEle = this.toKeyCell(factory, key);
        Element valueElement = factory.createCell();
        for (int j = 0; j < size; ++j) {
            if (j > 0) {
                valueElement.addContent((Content)factory.createLB());
            }
            String text = this.configAll.get(key, j);
            if (type != null && !type.isText() && type.isAllowed(text)) {
                text = type.convert(text).toString();
            }
            text = XMLUtil.escape(text);
            if (type != null && type.allowsRTF()) {
                valueElement.addContent(OSISUtil.rtfToOsis(text));
                continue;
            }
            valueElement.addContent(text);
        }
        Element rowEle = factory.createRow();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        return rowEle;
    }

    private Element toKeyCell(OSISUtil.OSISFactory factory, String key) {
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        hiEle.addContent(key);
        return nameEle;
    }

    IniSection getConfiguration() {
        return this.configAll;
    }

    private void adjustConfig() {
        this.adjustLanguage();
        this.adjustBookType();
        this.adjustName();
        this.adjustHistory();
    }

    private void adjustLanguage() {
        String lang = this.getProperty("Lang");
        this.testLanguage("Lang", lang);
        String langFrom = this.configAll.get(KEY_GLOSSARY_FROM);
        String langTo = this.configAll.get(KEY_GLOSSARY_TO);
        if (langFrom != null || langTo != null) {
            if (langFrom == null) {
                langFrom = lang;
                this.configAll.replace(KEY_GLOSSARY_FROM, langFrom);
                log.warn("Missing data for [{}]. Assuming {}={}", new Object[]{this.configSword.getName(), KEY_GLOSSARY_FROM, langFrom});
            }
            this.testLanguage(KEY_GLOSSARY_FROM, langFrom);
            if (langTo == null) {
                langTo = Language.DEFAULT_LANG.getGivenSpecification();
                this.configAll.replace(KEY_GLOSSARY_TO, langTo);
                log.warn("Missing data for [{}]. Assuming {}={}", new Object[]{this.configSword.getName(), KEY_GLOSSARY_TO, langTo});
            }
            this.testLanguage(KEY_GLOSSARY_TO, langTo);
            if (!langFrom.equals(lang) && !langTo.equals(lang)) {
                log.error("Data error in [{}]. Neither {} or {} match {}", new Object[]{this.configSword.getName(), KEY_GLOSSARY_FROM, KEY_GLOSSARY_TO, "Lang"});
            }
        }
        this.setLanguage((Language)this.getValue("Lang"));
    }

    private void testLanguage(String key, String lang) {
        Language language = new Language(lang);
        if (!language.isValidLanguage()) {
            log.warn("Unknown language [{}]{}={}", new Object[]{this.configSword.getName(), key, lang});
        }
    }

    private void adjustBookType() {
        BookCategory focusedCategory = (BookCategory)((Object)this.getValue("Category"));
        this.questionable = focusedCategory == BookCategory.QUESTIONABLE;
        String modTypeName = this.getProperty(KEY_MOD_DRV);
        if (modTypeName == null) {
            log.error("Book not supported: malformed conf file for [{}] no {} found.", (Object)this.configSword.getName(), (Object)KEY_MOD_DRV);
            this.supported = false;
            return;
        }
        String v11n = this.getProperty("Versification");
        if (!Versifications.instance().isDefined(v11n)) {
            log.error("Book not supported: Unknown versification for [{}]{}={}.", new Object[]{this.configSword.getName(), "Versification", v11n});
            this.supported = false;
            return;
        }
        this.bookType = BookType.fromString(modTypeName);
        if (this.bookType == null) {
            log.error("Book not supported: malformed conf file for [{}] no book type found", (Object)this.configSword.getName());
            this.supported = false;
            return;
        }
        BookCategory basicCategory = this.bookType.getBookCategory();
        if (basicCategory == null) {
            this.supported = false;
            return;
        }
        if (focusedCategory == BookCategory.OTHER || focusedCategory == BookCategory.QUESTIONABLE) {
            focusedCategory = this.bookType.getBookCategory();
        }
        this.configAll.replace("Category", focusedCategory.getName());
    }

    private void adjustName() {
        if (this.configAll.get(KEY_DESCRIPTION) == null) {
            log.error("Malformed conf file: missing [{}]{}=. Using {}", new Object[]{this.configSword.getName(), KEY_DESCRIPTION, this.configSword.getName()});
            this.configAll.replace(KEY_DESCRIPTION, this.configSword.getName());
        }
    }

    private void adjustHistory() {
        ArrayList<String> keys = new ArrayList<String>(this.configAll.getKeys());
        for (String key : keys) {
            String value = this.configAll.get(key);
            ConfigEntryType type = ConfigEntryType.fromString(key);
            if (!ConfigEntryType.HISTORY.equals((Object)type)) continue;
            this.configAll.remove(key);
            int pos = key.indexOf(95);
            value = key.substring(pos + 1) + ' ' + value;
            this.configAll.add(KEY_HISTORY, value);
        }
    }

    protected void report() {
        for (String key : this.configAll.getKeys()) {
            int count = this.configAll.size(key);
            if (count == 0) {
                log.error("Entry has no values [{}]{}", (Object)this.configAll.getName(), (Object)key);
                continue;
            }
            ConfigEntryType type = ConfigEntryType.fromString(key);
            String value = this.configAll.get(key);
            if (value == null) {
                log.error("Entry has a null value [{}]{}", (Object)this.configAll.getName(), (Object)key);
                continue;
            }
            if (value.length() == 0 && type != ConfigEntryType.CIPHER_KEY) {
                log.warn("Unexpected empty entry in [{}]{} = ", (Object)this.configAll.getName(), (Object)key);
                continue;
            }
            if (type == null && key.contains("_")) {
                String baseKey = key.substring(0, key.indexOf(95));
                type = ConfigEntryType.fromString(baseKey);
            }
            for (int i = 1; i < count; ++i) {
                value = this.configAll.get(key, i);
                if (value == null) {
                    log.error("Entry has a null value [{}]{}", (Object)this.configAll.getName(), (Object)key);
                    continue;
                }
                if (value.length() == 0 && type != ConfigEntryType.CIPHER_KEY) {
                    log.warn("Unexpected empty entry in [{}]{} = ", (Object)this.configAll.getName(), (Object)key);
                    continue;
                }
                if (type == null) continue;
                value = type.filter(value);
                if (!type.allowsRTF() && RTF_PATTERN.matcher(value).find()) {
                    log.info("Unexpected RTF for [{}]{} = {}", new Object[]{this.configAll.getName(), key, value});
                }
                if (!type.isAllowed(value)) {
                    log.info("Unknown config value for [{}]{} = {}", new Object[]{this.configAll.getName(), key, value});
                }
                if (count <= 1 || type.mayRepeat()) continue;
                log.info("Unexpected repeated config key for [{}]{} = {}", new Object[]{this.configAll.getName(), key, value});
            }
            if (type != null) continue;
            log.info("Unknown entry in [{}]{} = {}", new Object[]{this.configAll.getName(), key, value});
        }
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(KEY_COMPRESS_TYPE, "LZSS");
        tempMap.put(KEY_BLOCK_TYPE, "CHAPTER");
        tempMap.put(KEY_BLOCK_COUNT, "200");
        tempMap.put(KEY_KEY_TYPE, "TreeKey");
        tempMap.put("Versification", "KJV");
        tempMap.put(KEY_DIRECTION, "LtoR");
        tempMap.put(KEY_SOURCE_TYPE, "Plaintext");
        tempMap.put(KEY_ENCODING, "Latin-1");
        tempMap.put(KEY_DISPLAY_LEVEL, "1");
        tempMap.put(KEY_OSIS_Q_TO_TICK, "true");
        tempMap.put(KEY_VERSION, "1.0");
        tempMap.put(KEY_MINIMUM_VERSION, "1.5.1a");
        tempMap.put("Category", "Other");
        tempMap.put("Lang", "en");
        tempMap.put(KEY_DISTRIBUTION_LICENSE, "Public Domain");
        DEFAULTS = Collections.unmodifiableMap(tempMap);
        OSIS_INFO = new String[]{KEY_ABBREVIATION, KEY_DESCRIPTION, "Category", KEY_LCSH, KEY_SWORD_VERSION_DATE, KEY_VERSION, KEY_HISTORY, KEY_OBSOLETES, KEY_INSTALL_SIZE, "Lang", KEY_GLOSSARY_FROM, KEY_GLOSSARY_TO, KEY_ABOUT, KEY_SHORT_PROMO, KEY_DISTRIBUTION_LICENSE, KEY_DISTRIBUTION_NOTES, KEY_DISTRIBUTION_SOURCE, KEY_SHORT_COPYRIGHT, KEY_COPYRIGHT, KEY_COPYRIGHT_DATE, KEY_COPYRIGHT_HOLDER, KEY_COPYRIGHT_CONTACT_NAME, KEY_COPYRIGHT_CONTACT_ADDRESS, KEY_COPYRIGHT_CONTACT_EMAIL, KEY_COPYRIGHT_CONTACT_NOTES, KEY_COPYRIGHT_NOTES, KEY_TEXT_SOURCE, KEY_FEATURE, KEY_GLOBAL_OPTION_FILTER, "Font", KEY_DATA_PATH, KEY_MOD_DRV, KEY_SOURCE_TYPE, KEY_BLOCK_TYPE, KEY_BLOCK_COUNT, KEY_COMPRESS_TYPE, KEY_ENCODING, KEY_MINIMUM_VERSION, KEY_OSIS_VERSION, KEY_OSIS_Q_TO_TICK, KEY_DIRECTION, KEY_KEY_TYPE, KEY_DISPLAY_LEVEL, "Versification", "Scope", "BookList"};
        HIDDEN = new String[]{KEY_CIPHER_KEY, "Language"};
        RTF_PATTERN = Pattern.compile("\\\\pard|\\\\pa[er]|\\\\qc|\\\\[bi]|\\\\u-?[0-9]{4,6}+");
        ENCODING_JAVA = new PropertyMap();
        ENCODING_JAVA.put("Latin-1", ENCODING_LATIN1);
        ENCODING_JAVA.put(ENCODING_UTF8, ENCODING_UTF8);
        log = LoggerFactory.getLogger(SwordBookMetaData.class);
    }
}

