/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.basic.DefaultBookMetaData;
import org.crosswire.jsword.book.readings.ReadingsBookDriver;
import org.crosswire.jsword.book.readings.ReadingsKey;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.internationalisation.LocaleProviderManager;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.PreferredKey;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.SetKeyList;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingsBook
extends AbstractBook
implements PreferredKey {
    private Key global;
    private Map<Key, String> hash = new TreeMap<Key, String>();
    private static final Logger log = LoggerFactory.getLogger(ReadingsBook.class);

    public ReadingsBook(ReadingsBookDriver driver, String setname, BookCategory type) {
        super(null, null);
        Locale defaultLocale = LocaleProviderManager.getLocale();
        ResourceBundle prop = ResourceBundle.getBundle(setname, defaultLocale, CWClassLoader.instance(ReadingsBookDriver.class));
        String name = JSMsg.gettext("Readings", new Object[0]);
        try {
            name = prop.getString("title");
        }
        catch (MissingResourceException e) {
            log.warn("Missing resource: 'title' while parsing: {}", (Object)setname);
        }
        DefaultBookMetaData bmd = new DefaultBookMetaData(driver, name, type);
        bmd.setInitials(setname);
        bmd.setLanguage(new Language(defaultLocale.getLanguage()));
        this.setBookMetaData(bmd);
        GregorianCalendar greg = new GregorianCalendar();
        greg.set(5, 1);
        greg.set(2, 0);
        int currentYear = greg.get(1);
        while (greg.get(1) == currentYear) {
            String internalKey = ReadingsKey.external2internal(greg);
            String readings = "";
            try {
                readings = prop.getString(internalKey);
                this.hash.put(new ReadingsKey(greg.getTime()), readings);
            }
            catch (MissingResourceException e) {
                log.warn("Missing resource: {} while parsing: {}", (Object)internalKey, (Object)setname);
            }
            ((Calendar)greg).add(5, 1);
        }
        this.global = new SetKeyList(this.hash.keySet(), this.getName());
    }

    @Override
    public Key getPreferred() {
        return new ReadingsKey(new Date());
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, boolean allowEmpty, boolean allowGenTitles) throws BookException {
        if (!(key instanceof ReadingsKey)) {
            throw new BookException(JSMsg.gettext("Key not found {0}", key.getName()));
        }
        ArrayList<Object> content = new ArrayList<Object>();
        Element title = OSISUtil.factory().createTitle();
        title.addContent(key.getName());
        content.add(title);
        String readings = this.hash.get(key);
        if (readings == null) {
            throw new BookException(JSMsg.gettext("Key not found {0}", key.getName()));
        }
        try {
            PassageKeyFactory keyf = PassageKeyFactory.instance();
            Passage ref = keyf.getKey(Versifications.instance().getVersification("KJV"), readings);
            Element list = OSISUtil.factory().createList();
            content.add(list);
            Iterator<VerseRange> it = ref.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                Key range = it.next();
                Element reading = OSISUtil.factory().createReference();
                reading.setAttribute("osisRef", range.getOsisRef());
                reading.addContent(range.getName());
                Element item = OSISUtil.factory().createItem();
                item.addContent((Content)reading);
                list.addContent((Content)item);
            }
        }
        catch (NoSuchKeyException ex) {
            content.add(OSISUtil.factory().createText(JSOtherMsg.lookupText("Failed to parse {0}", readings)));
        }
        return content.iterator();
    }

    @Override
    public boolean contains(Key key) {
        return false;
    }

    @Override
    public String getRawText(Key key) throws BookException {
        return "";
    }

    @Override
    public List<Content> getOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        return Collections.emptyList();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public Key getKey(String name) throws NoSuchKeyException {
        DefaultKeyList reply = new DefaultKeyList();
        reply.addAll(new ReadingsKey(name, name, this.global));
        return reply;
    }

    @Override
    public Key getGlobalKeyList() {
        return this.global;
    }

    @Override
    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        return feature == FeatureType.DAILY_DEVOTIONS;
    }
}

