/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.jsword.internationalisation.LocaleProviderManager;

public abstract class CaseType
extends Enum<CaseType> {
    public static final /* enum */ CaseType LOWER = new CaseType(){

        @Override
        public String setCase(String word) {
            return word.toLowerCase(LocaleProviderManager.getLocale());
        }
    };
    public static final /* enum */ CaseType SENTENCE = new CaseType(){

        @Override
        public String setCase(String word) {
            int index = word.indexOf(45);
            if (index == -1) {
                return 2.toSentenceCase(word);
            }
            if ("maher-shalal-hash-baz".equalsIgnoreCase(word)) {
                return "Maher-Shalal-Hash-Baz";
            }
            if ("no-one".equalsIgnoreCase(word)) {
                return "No-one";
            }
            if ("god-".equalsIgnoreCase(word.substring(0, 4))) {
                return 2.toSentenceCase(word);
            }
            return 2.toSentenceCase(word.substring(0, index)) + "-" + 2.toSentenceCase(word.substring(index + 1));
        }
    };
    public static final /* enum */ CaseType UPPER = new CaseType(){

        @Override
        public String setCase(String word) {
            return word.toUpperCase(LocaleProviderManager.getLocale());
        }
    };
    private static final /* synthetic */ CaseType[] $VALUES;

    public static CaseType[] values() {
        return (CaseType[])$VALUES.clone();
    }

    public static CaseType valueOf(String name) {
        return Enum.valueOf(CaseType.class, name);
    }

    public abstract String setCase(String var1);

    public static String toSentenceCase(String word) {
        assert (word != null);
        if (word.length() == 0) {
            return "";
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase(LocaleProviderManager.getLocale());
    }

    public static CaseType getCase(String word) {
        assert (word != null);
        if (word.length() == 0) {
            return LOWER;
        }
        if (word.equals(word.toLowerCase(LocaleProviderManager.getLocale()))) {
            return LOWER;
        }
        if (word.equals(word.toUpperCase(LocaleProviderManager.getLocale())) && word.length() != 1) {
            return UPPER;
        }
        return SENTENCE;
    }

    public int toInteger() {
        return this.ordinal();
    }

    public static CaseType fromString(String name) {
        for (CaseType v : CaseType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        assert (false);
        return null;
    }

    public static CaseType fromInteger(int i) {
        for (CaseType v : CaseType.values()) {
            if (v.ordinal() != i) continue;
            return v;
        }
        assert (false);
        return null;
    }

    static {
        $VALUES = new CaseType[]{LOWER, SENTENCE, UPPER};
    }
}

