/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.compress;

import java.io.ByteArrayInputStream;
import org.crosswire.common.compress.BZip2;
import org.crosswire.common.compress.Compressor;
import org.crosswire.common.compress.Gzip;
import org.crosswire.common.compress.LZSS;
import org.crosswire.common.compress.XZ;
import org.crosswire.common.compress.Zip;

public abstract class CompressorType
extends Enum<CompressorType> {
    public static final /* enum */ CompressorType ZIP = new CompressorType(){

        @Override
        public Compressor getCompressor(byte[] input) {
            return new Zip(new ByteArrayInputStream(input));
        }
    };
    public static final /* enum */ CompressorType LZSS = new CompressorType(){

        @Override
        public Compressor getCompressor(byte[] input) {
            return new LZSS(new ByteArrayInputStream(input));
        }
    };
    public static final /* enum */ CompressorType BZIP2 = new CompressorType(){

        @Override
        public Compressor getCompressor(byte[] input) {
            return new BZip2(new ByteArrayInputStream(input));
        }
    };
    public static final /* enum */ CompressorType GZIP = new CompressorType(){

        @Override
        public Compressor getCompressor(byte[] input) {
            return new Gzip(new ByteArrayInputStream(input));
        }
    };
    public static final /* enum */ CompressorType XZ = new CompressorType(){

        @Override
        public Compressor getCompressor(byte[] input) {
            return new XZ(new ByteArrayInputStream(input));
        }
    };
    private static final /* synthetic */ CompressorType[] $VALUES;

    public static CompressorType[] values() {
        return (CompressorType[])$VALUES.clone();
    }

    public static CompressorType valueOf(String name) {
        return Enum.valueOf(CompressorType.class, name);
    }

    public abstract Compressor getCompressor(byte[] var1);

    public static CompressorType fromString(String name) {
        for (CompressorType v : CompressorType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        assert (false);
        return null;
    }

    static {
        $VALUES = new CompressorType[]{ZIP, LZSS, BZIP2, GZIP, XZ};
    }
}

