/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWMsg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.NumberCellRenderer;

public class FontChooser
extends JPanel {
    public static final String PROPERTY_STYLE = "style";
    protected static final JLabel DEFAULT_FONT = new JLabel();
    protected JDialog dialog;
    protected Font font;
    private static final int MIN_FONT_SIZE = 5;
    private static final int MAX_FONT_SIZE = 72;
    private static final int RENDERED_FONT_SIZE = 16;
    protected JComboBox name;
    protected JCheckBox bold;
    protected JCheckBox italic;
    protected JComboBox size;
    protected boolean suppressEvents;
    private static final long serialVersionUID = 3978992071925250097L;

    public FontChooser() {
        ItemListener changer = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                FontChooser.this.fireStateChange();
            }
        };
        this.font = DEFAULT_FONT.getFont();
        this.name = new FontNameComboBox();
        this.name.setModel(new CustomComboBoxModel());
        this.name.setRenderer(new CustomListCellRenderer());
        this.name.setSelectedItem(this.font.deriveFont(0, 16.0f));
        this.name.addItemListener(changer);
        this.size = new JComboBox();
        this.size.setRenderer(new NumberCellRenderer());
        for (int i = 5; i <= 72; ++i) {
            this.size.addItem(i);
        }
        this.size.setSelectedItem(16);
        this.size.addItemListener(changer);
        this.bold = new JCheckBox(CWMsg.gettext("Bold", new Object[0]));
        this.bold.setSelected(this.font.isBold());
        this.bold.addItemListener(changer);
        this.italic = new JCheckBox(CWMsg.gettext("Italic", new Object[0]));
        this.italic.setSelected(this.font.isItalic());
        this.italic.addItemListener(changer);
        this.setLayout(new GridLayout(2, 2, 5, 5));
        this.add(this.name);
        this.add(this.size);
        this.add(this.bold);
        this.add(this.italic);
        GuiUtil.applyDefaultOrientation(this);
    }

    public static Font showDialog(Component parent, String title, Font initial) {
        final FontChooser fontc = new FontChooser();
        Component root = SwingUtilities.getRoot(parent);
        fontc.dialog = root instanceof JFrame ? new JDialog((JFrame)root, title, true) : new JDialog((JDialog)root, title, true);
        Font font = initial != null ? initial : DEFAULT_FONT.getFont();
        fontc.name.setSelectedItem(font);
        fontc.bold.setSelected(font.isBold());
        fontc.italic.setSelected(font.isItalic());
        fontc.size.setSelectedItem(font.getSize());
        ActionFactory actions = new ActionFactory(fontc);
        JButton ok = actions.createJButton(actions.addAction("OK", CWMsg.gettext("OK", new Object[0])), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fontc.dialog.dispose();
            }
        });
        JButton cancel = actions.createJButton(actions.addAction("Cancel", CWMsg.gettext("Cancel", new Object[0])), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                fontc.dialog.setVisible(false);
                fontc.font = null;
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(ok);
        buttons.add(cancel);
        fontc.setBorder(BorderFactory.createTitledBorder(CWMsg.gettext("Select Font", new Object[0])));
        fontc.dialog.getRootPane().setDefaultButton(ok);
        fontc.dialog.getContentPane().setLayout(new BorderLayout());
        fontc.dialog.getContentPane().add((Component)fontc, "North");
        fontc.dialog.getContentPane().add((Component)buttons, "South");
        fontc.dialog.setSize(800, 500);
        fontc.dialog.pack();
        GuiUtil.centerOnScreen(fontc.dialog);
        GuiUtil.applyDefaultOrientation(fontc.dialog);
        fontc.dialog.setVisible(true);
        fontc.dialog.dispose();
        return fontc.font;
    }

    public void setStyle(Font newFont) {
        this.suppressEvents = true;
        if (newFont == null) {
            return;
        }
        CustomComboBoxModel model = (CustomComboBoxModel)this.name.getModel();
        model.setSelectedItem(newFont.deriveFont(0, 16.0f));
        this.bold.setSelected(newFont.isBold());
        this.italic.setSelected(newFont.isItalic());
        this.size.setSelectedItem(newFont.getSize());
        this.suppressEvents = false;
        this.fireStateChange();
    }

    public Font getStyle() {
        Font selected = (Font)this.name.getSelectedItem();
        if (selected == null) {
            return DEFAULT_FONT.getFont();
        }
        int font_style = (this.bold.isSelected() ? 1 : 0) | (this.italic.isSelected() ? 2 : 0);
        int font_size = (Integer)this.size.getSelectedItem();
        return selected.deriveFont(font_style, font_size);
    }

    protected void fireStateChange() {
        Font old = this.font;
        this.font = this.getStyle();
        if (!this.suppressEvents) {
            this.firePropertyChange(PROPERTY_STYLE, old, this.font);
        }
    }

    static class FontNameComboBox
    extends JComboBox {
        private static final long serialVersionUID = -7394816349446551753L;

        FontNameComboBox() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if ((this.selectedItemReminder == null || !this.selectedItemReminder.equals(anObject)) && anObject instanceof Font) {
                String fontName = ((Font)anObject).getName();
                for (int i = 0; i < this.dataModel.getSize(); ++i) {
                    Object element = this.dataModel.getElementAt(i);
                    if (!(element instanceof Font) || !((Font)element).getName().equals(fontName)) continue;
                    super.setSelectedItem(element);
                    return;
                }
            }
        }
    }

    static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3256726195025358905L;

        public CustomListCellRenderer() {
            GuiUtil.applyDefaultOrientation(this);
        }

        @Override
        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean selected, boolean focus) {
            Font defaultFont = DEFAULT_FONT.getFont();
            if (value == null) {
                this.setText("<null>");
                this.setFont(defaultFont);
            } else {
                Font afont = (Font)value;
                this.setText(afont.getFamily());
                this.setFont(defaultFont);
            }
            return this;
        }
    }

    static class CustomComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int fontCount;
        private Font[] fonts;
        private Object selection;
        private static final long serialVersionUID = 3258129150505071664L;

        protected CustomComboBoxModel() {
            String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fonts = new Font[names.length];
            for (int i = 0; i < this.fonts.length; ++i) {
                if ("padmaa".equals(names[i]) || "Rekha".equals(names[i]) || names[i].indexOf("Lohit") > -1 || names[i].indexOf("aakar") > -1) continue;
                this.fonts[this.fontCount++] = new Font(names[i], 0, 16);
            }
        }

        @Override
        public void setSelectedItem(Object selection) {
            this.selection = selection;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selection;
        }

        @Override
        public int getSize() {
            return this.fontCount;
        }

        @Override
        public Object getElementAt(int index) {
            return this.fonts[index];
        }
    }
}

