/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.util.Version;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class ThaiLuceneAnalyzer
extends AbstractBookAnalyzer {
    private final Version matchVersion = Version.LUCENE_29;

    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer ts = new StandardTokenizer(this.matchVersion, reader);
        ts = new ThaiWordFilter((TokenStream)ts);
        if (this.doStopWords && this.stopSet != null) {
            ts = new StopFilter(false, (TokenStream)ts, this.stopSet);
        }
        return ts;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new StandardTokenizer(this.matchVersion, reader));
            streams.setResult((TokenStream)new ThaiWordFilter(streams.getResult()));
            if (this.doStopWords && this.stopSet != null) {
                streams.setResult((TokenStream)new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.getResult(), this.stopSet));
            }
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
            streams.getResult().reset();
        }
        return streams.getResult();
    }
}

