/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.diff.Diff;
import org.crosswire.common.diff.DiffCleanup;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.util.Language;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookProvider;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.UnAccenter;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class BookData
implements BookProvider {
    private Key key;
    private Book[] books;
    private boolean comparingBooks;
    private Element osis;
    private Element fragment;
    private UnAccenter unaccenter;

    public BookData(Book book, Key key) {
        assert (book != null);
        assert (key != null);
        this.key = key;
        this.books = new Book[1];
        this.books[0] = book;
    }

    public BookData(Book[] books, Key key, boolean compare) {
        assert (books != null && books.length > 0);
        assert (key != null);
        this.books = (Book[])books.clone();
        this.key = key;
        this.comparingBooks = compare;
    }

    public Element getOsis() throws BookException {
        if (this.osis == null) {
            this.osis = OSISUtil.createOsisFramework(this.getFirstBook().getBookMetaData());
            Element text = this.osis.getChild("osisText");
            Element div = this.getOsisFragment();
            text.addContent((Content)div);
        }
        return this.osis;
    }

    public Element getOsisFragment() throws BookException {
        if (this.fragment == null) {
            this.fragment = this.getOsisContent();
        }
        return this.fragment;
    }

    public SAXEventProvider getSAXEventProvider() throws BookException {
        Element frag = this.getOsisFragment();
        Document doc = frag.getDocument();
        if (doc == null) {
            doc = new Document(frag);
        }
        return new JDOMSAXEventProvider(doc);
    }

    @Override
    public Book[] getBooks() {
        return this.books == null ? null : (Book[])this.books.clone();
    }

    @Override
    public Book getFirstBook() {
        return this.books != null && this.books.length > 0 ? this.books[0] : null;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isComparingBooks() {
        return this.comparingBooks;
    }

    private Element getOsisContent() throws BookException {
        Element div = OSISUtil.factory().createDiv();
        if (this.books.length == 1) {
            Iterator<Content> iter = this.books[0].getOsisIterator(this.key, false);
            while (iter.hasNext()) {
                Content content = iter.next();
                div.addContent(content);
            }
        } else {
            Element table = OSISUtil.factory().createTable();
            Element row = OSISUtil.factory().createRow();
            Element cell = null;
            table.addContent((Content)row);
            Iterator[] iters = new Iterator[this.books.length];
            boolean[] showDiffs = new boolean[this.books.length - 1];
            boolean doDiffs = false;
            for (int i = 0; i < this.books.length; ++i) {
                Book book = this.books[i];
                cell = OSISUtil.factory().createHeaderCell();
                if (i > 0) {
                    Book firstBook = this.books[0];
                    BookCategory category = book.getBookCategory();
                    BookCategory prevCategory = firstBook.getBookCategory();
                    String prevName = firstBook.getInitials();
                    boolean bl = showDiffs[i - 1] = this.comparingBooks && BookCategory.BIBLE.equals((Object)category) && category.equals((Object)prevCategory) && book.getLanguage().equals(firstBook.getLanguage()) && !book.getInitials().equals(prevName);
                    if (showDiffs[i - 1]) {
                        doDiffs = true;
                        StringBuilder buf = new StringBuilder(firstBook.getInitials());
                        buf.append(" ==> ");
                        buf.append(book.getInitials());
                        cell.addContent((Content)OSISUtil.factory().createText(buf.toString()));
                        row.addContent((Content)cell);
                        cell = OSISUtil.factory().createHeaderCell();
                    }
                }
                cell.addContent((Content)OSISUtil.factory().createText(book.getInitials()));
                row.addContent((Content)cell);
                iters[i] = book.getOsisIterator(this.key, true);
            }
            Content content = null;
            int cellCount = 0;
            int rowCount = 0;
            while (true) {
                cellCount = 0;
                row = OSISUtil.factory().createRow();
                String firstText = "";
                for (int i = 0; i < iters.length; ++i) {
                    Book book = this.books[i];
                    cell = OSISUtil.factory().createCell();
                    Language lang = (Language)book.getProperty("Lang");
                    if (lang != null) {
                        cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                    }
                    row.addContent((Content)cell);
                    StringBuilder newText = new StringBuilder(doDiffs ? 32 : 0);
                    if (!iters[i].hasNext()) continue;
                    ArrayList<Content> contents = new ArrayList<Content>(1);
                    do {
                        content = (Content)iters[i].next();
                        contents.add(content);
                        this.addText(doDiffs, newText, content);
                    } while (!this.isNextVerse(content));
                    if (doDiffs) {
                        String thisText = newText.toString();
                        if (this.unaccenter != null) {
                            thisText = this.unaccenter.unaccent(thisText);
                        }
                        if (i > 0 && showDiffs[i - 1]) {
                            List<Difference> diffs = new Diff(firstText, thisText, false).compare();
                            DiffCleanup.cleanupSemantic(diffs);
                            cell.addContent(OSISUtil.diffToOsis(diffs));
                            cell = OSISUtil.factory().createCell();
                            lang = (Language)book.getProperty("Lang");
                            cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                            row.addContent((Content)cell);
                        }
                        if (i == 0) {
                            firstText = thisText;
                        }
                    }
                    cell.addContent(contents);
                    ++cellCount;
                }
                if (cellCount == 0) break;
                table.addContent((Content)row);
                ++rowCount;
            }
            if (rowCount > 0) {
                div.addContent((Content)table);
            }
        }
        return div;
    }

    private boolean isNextVerse(Content content) {
        if (content instanceof Element) {
            return "verse".equals(((Element)content).getName());
        }
        return false;
    }

    private void addText(boolean doDiffs, StringBuilder newText, Content content) {
        if (doDiffs) {
            if (newText.length() != 0) {
                newText.append(' ');
            }
            if (content instanceof Element) {
                newText.append(OSISUtil.getCanonicalText((Element)content));
            } else if (content instanceof Text) {
                newText.append(((Text)content).getText());
            }
        }
    }

    public void setUnaccenter(UnAccenter unaccenter) {
        this.unaccenter = unaccenter;
    }
}

