/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final String EXTENSION_CLASS = ".class";
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_ZIP = ".zip";
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);

    private ClassUtil() {
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findClasspathEntry(String classname, String classpath) {
        String full = null;
        String[] paths = StringUtil.split(classpath, File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].endsWith(EXTENSION_ZIP) || paths[i].endsWith(EXTENSION_JAR)) {
                ZipFile zip = null;
                try {
                    String fileName = classname.replace(',', '/') + EXTENSION_CLASS;
                    zip = new ZipFile(paths[i]);
                    ZipEntry entry = zip.getEntry(fileName);
                    if (entry != null && !entry.isDirectory()) {
                        if (full != null && !full.equals(fileName)) {
                            log.warn("Warning duplicate {} found: {} and {}", new Object[]{classname, full, paths[i]});
                        } else {
                            full = paths[i];
                        }
                    }
                    IOUtil.close(zip);
                    continue;
                }
                catch (IOException ex) {
                    log.warn("Missing zip file for {} and {}", (Object)classname, (Object)paths[i]);
                    continue;
                }
                finally {
                    IOUtil.close(zip);
                }
            }
            StringBuilder path = new StringBuilder(256);
            String extra = classname.replace('.', File.separatorChar);
            path.append(paths[i]);
            if (paths[i].charAt(paths[i].length() - 1) != File.separatorChar) {
                path.append(File.separatorChar);
            }
            path.append(extra);
            path.append(EXTENSION_CLASS);
            String fileName = path.toString();
            if (!new File(fileName).isFile()) continue;
            if (full != null && !full.equals(fileName)) {
                log.warn("Warning duplicate {} found: {} and {}", new Object[]{classname, full, paths[i]});
                continue;
            }
            full = paths[i];
        }
        return full;
    }

    public static String findClasspathEntry(String classname) {
        String classpath = System.getProperty("java.class.path", "");
        return ClassUtil.findClasspathEntry(classname, classpath);
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtil.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtil.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }
}

