/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VerseRange
implements VerseKey {
    public static final String RANGE_ALLOWED_DELIMS = "-";
    public static final String RANGE_PREF_DELIM = "-";
    private transient Versification v11n;
    private Verse start;
    private int verseCount;
    private transient Verse end;
    private transient NumberShaper shaper;
    private transient Key parent;
    private transient String originalName;
    static final transient Logger log = LoggerFactory.getLogger(VerseRange.class);
    static final long serialVersionUID = 8307795549869653580L;

    @Deprecated
    public VerseRange() {
        this(null, null, Verse.DEFAULT, Verse.DEFAULT);
    }

    @Deprecated
    public VerseRange(Verse start) {
        this(null, null, start, start);
    }

    @Deprecated
    public VerseRange(Verse start, Verse end) {
        this(null, null, start, end);
    }

    public VerseRange(Versification v11n) {
        this(v11n, null, Verse.DEFAULT, Verse.DEFAULT);
    }

    public VerseRange(Versification v11n, Verse start) {
        this(v11n, null, start, start);
    }

    public VerseRange(Versification v11n, Verse start, Verse end) {
        this(v11n, null, start, end);
    }

    @Deprecated
    VerseRange(String original, Verse start, Verse end) {
        this(null, original, start, end);
    }

    VerseRange(Versification v11n, String original, Verse start, Verse end) {
        assert (v11n != null);
        assert (start != null);
        assert (end != null);
        this.v11n = v11n;
        this.originalName = original;
        this.shaper = new NumberShaper();
        int distance = v11n.distance(start, end);
        if (distance < 0) {
            this.start = end;
            this.end = start;
            this.verseCount = this.calcVerseCount();
        } else if (distance == 0) {
            this.start = start;
            this.end = start;
            this.verseCount = 1;
        } else {
            this.start = start;
            this.end = end;
            this.verseCount = this.calcVerseCount();
        }
        this.verifyData();
    }

    @Override
    public Versification getVersification() {
        return this.v11n;
    }

    public VerseRange(VerseRange a, VerseRange b) {
        this.v11n = a.v11n;
        this.shaper = new NumberShaper();
        this.start = this.v11n.min(a.getStart(), b.getStart());
        this.end = this.v11n.max(a.getEnd(), b.getEnd());
        this.verseCount = this.calcVerseCount();
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getName(Key base) {
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        String rangeName = this.doGetName(base);
        if (this.shaper.canUnshape()) {
            return this.shaper.shape(rangeName);
        }
        return rangeName;
    }

    @Override
    public String getRootName() {
        return this.start.getRootName();
    }

    @Override
    public String getOsisRef() {
        BibleBook startBook = this.start.getBook();
        BibleBook endBook = this.end.getBook();
        int startChapter = this.start.getChapter();
        int endChapter = this.end.getChapter();
        if (startBook != endBook) {
            StringBuilder buf = new StringBuilder();
            if (this.v11n.isStartOfBook(this.start)) {
                buf.append(startBook.getOSIS());
            } else if (this.v11n.isStartOfChapter(this.start)) {
                buf.append(startBook.getOSIS());
                buf.append(".");
                buf.append(startChapter);
            } else {
                buf.append(this.start.getOsisRef());
            }
            buf.append("-");
            if (this.v11n.isEndOfBook(this.end)) {
                buf.append(endBook.getOSIS());
            } else if (this.v11n.isEndOfChapter(this.end)) {
                buf.append(endBook.getOSIS());
                buf.append(".");
                buf.append(endChapter);
            } else {
                buf.append(this.end.getOsisRef());
            }
            return buf.toString();
        }
        if (this.isWholeBook()) {
            return startBook.getOSIS();
        }
        if (startChapter != endChapter) {
            StringBuilder buf = new StringBuilder();
            if (this.v11n.isStartOfChapter(this.start)) {
                buf.append(startBook.getOSIS());
                buf.append(".");
                buf.append(startChapter);
            } else {
                buf.append(this.start.getOsisRef());
            }
            buf.append("-");
            if (this.v11n.isEndOfChapter(this.end)) {
                buf.append(endBook.getOSIS());
                buf.append(".");
                buf.append(endChapter);
            } else {
                buf.append(this.end.getOsisRef());
            }
            return buf.toString();
        }
        if (this.isWholeChapter()) {
            StringBuilder buf = new StringBuilder();
            buf.append(startBook.getOSIS());
            buf.append(".");
            buf.append(startChapter);
            return buf.toString();
        }
        if (this.start.getVerse() != this.end.getVerse()) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.start.getOsisRef());
            buf.append("-");
            buf.append(this.end.getOsisRef());
            return buf.toString();
        }
        return this.start.getOsisRef();
    }

    @Override
    public String getOsisID() {
        if (this.isWholeBook()) {
            return this.start.getBook().getOSIS();
        }
        if (this.isWholeChapter()) {
            return this.start.getBook().getOSIS() + "." + this.start.getChapter();
        }
        int startOrdinal = this.start.getOrdinal();
        int endOrdinal = this.end.getOrdinal();
        StringBuilder buf = new StringBuilder((endOrdinal - startOrdinal + 1) * 10);
        buf.append(this.start.getOsisID());
        for (int i = startOrdinal + 1; i < endOrdinal; ++i) {
            buf.append(" ");
            buf.append(this.v11n.decodeOrdinal(i).getOsisID());
        }
        if (startOrdinal != endOrdinal) {
            buf.append(" ");
            buf.append(this.end.getOsisID());
        }
        return buf.toString();
    }

    public String toString() {
        return this.getName();
    }

    public Verse getStart() {
        return this.start;
    }

    public Verse getEnd() {
        return this.end;
    }

    @Deprecated
    public int getChapterCount() {
        return this.v11n.getChapterCount(this.start, this.end);
    }

    @Deprecated
    public int getBookCount() {
        return this.v11n.getBookCount(this.start, this.end);
    }

    @Override
    public VerseRange clone() {
        VerseRange copy;
        block2: {
            copy = null;
            try {
                copy = (VerseRange)super.clone();
                copy.start = this.start;
                copy.end = this.end;
                copy.verseCount = this.verseCount;
                copy.originalName = this.originalName;
                copy.shaper = new NumberShaper();
                copy.v11n = this.v11n;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        VerseRange vr = (VerseRange)obj;
        if (!vr.getStart().equals(this.getStart())) {
            return false;
        }
        return vr.getCardinality() == this.getCardinality();
    }

    @Override
    public int hashCode() {
        return (this.start.getOrdinal() << 16) + this.verseCount;
    }

    @Override
    public int compareTo(Key obj) {
        Verse that = null;
        that = obj instanceof Verse ? (Verse)obj : ((VerseRange)obj).getStart();
        int start_compare = this.getStart().compareTo(that);
        if (start_compare != 0) {
            return start_compare;
        }
        int that_length = 1;
        if (obj instanceof VerseRange) {
            that_length = ((VerseRange)obj).getCardinality();
        }
        if (that_length == this.getCardinality()) {
            return 0;
        }
        if (that_length < this.getCardinality()) {
            return 1;
        }
        return -1;
    }

    public boolean adjacentTo(VerseRange that) {
        int thatStart = that.getStart().getOrdinal();
        int thatEnd = that.getEnd().getOrdinal();
        int thisStart = this.getStart().getOrdinal();
        int thisEnd = this.getEnd().getOrdinal();
        if (thatStart >= thisStart - 1 && thatStart <= thisEnd + 1) {
            return true;
        }
        return thisStart >= thatStart - 1 && thisStart <= thatEnd + 1;
    }

    public boolean overlaps(VerseRange that) {
        int thatStart = that.getStart().getOrdinal();
        int thatEnd = that.getEnd().getOrdinal();
        int thisStart = this.getStart().getOrdinal();
        int thisEnd = this.getEnd().getOrdinal();
        if (thatStart >= thisStart && thatStart <= thisEnd) {
            return true;
        }
        return thisStart >= thatStart && thisStart <= thatEnd;
    }

    public boolean contains(Verse that) {
        return this.v11n.distance(this.start, that) >= 0 && this.v11n.distance(that, this.end) >= 0;
    }

    public boolean contains(VerseRange that) {
        return this.v11n.distance(this.start, that.getStart()) >= 0 && this.v11n.distance(that.getEnd(), this.end) >= 0;
    }

    public boolean isWholeChapter() {
        return this.v11n.isSameChapter(this.start, this.end) && this.isWholeChapters();
    }

    public boolean isWholeChapters() {
        return this.v11n.isStartOfChapter(this.start) && this.v11n.isEndOfChapter(this.end);
    }

    public boolean isWholeBook() {
        return this.v11n.isSameBook(this.start, this.end) && this.isWholeBooks();
    }

    public boolean isWholeBooks() {
        return this.v11n.isStartOfBook(this.start) && this.v11n.isEndOfBook(this.end);
    }

    public boolean isMultipleBooks() {
        return this.start.getBook() != this.end.getBook();
    }

    public Verse[] toVerseArray() {
        Verse[] retcode = new Verse[this.verseCount];
        int ord = this.start.getOrdinal();
        for (int i = 0; i < this.verseCount; ++i) {
            retcode[i] = this.v11n.decodeOrdinal(ord + i);
        }
        return retcode;
    }

    public Iterator<Key> rangeIterator(RestrictionType restrict) {
        return new AbstractPassage.VerseRangeIterator(this.v11n, this.iterator(), restrict);
    }

    @Override
    public Key getParent() {
        return this.parent;
    }

    public void setParent(Key parent) {
        this.parent = parent;
    }

    public static VerseRange[] remainder(VerseRange a, VerseRange b) {
        VerseRange rstart = null;
        VerseRange rend = null;
        Versification v11n = a.getVersification();
        if (v11n.distance(a.getStart(), b.getStart()) > 0) {
            rstart = new VerseRange(v11n, a.getStart(), v11n.subtract(b.getEnd(), 1));
        }
        if (v11n.distance(a.getEnd(), b.getEnd()) < 0) {
            rend = new VerseRange(v11n, v11n.add(b.getEnd(), 1), a.getEnd());
        }
        if (rstart == null) {
            if (rend == null) {
                return new VerseRange[0];
            }
            return new VerseRange[]{rend};
        }
        if (rend == null) {
            return new VerseRange[]{rstart};
        }
        return new VerseRange[]{rstart, rend};
    }

    public static VerseRange intersection(VerseRange a, VerseRange b) {
        Verse new_end;
        Verse new_start;
        Versification v11n = a.getVersification();
        if (v11n.distance(new_start = v11n.max(a.getStart(), b.getStart()), new_end = v11n.min(a.getEnd(), b.getEnd())) <= 0) {
            return new VerseRange(a.getVersification(), new_start, new_end);
        }
        return null;
    }

    private String doGetName(Key base) {
        BibleBook startBook = this.start.getBook();
        int startChapter = this.start.getChapter();
        int startVerse = this.start.getVerse();
        BibleBook endBook = this.end.getBook();
        int endChapter = this.end.getChapter();
        int endVerse = this.end.getVerse();
        if (startBook != endBook) {
            if (this.isWholeBooks()) {
                return this.v11n.getPreferredName(startBook) + "-" + this.v11n.getPreferredName(endBook);
            }
            if (this.isWholeChapters()) {
                return this.v11n.getPreferredName(startBook) + " " + startChapter + "-" + this.v11n.getPreferredName(endBook) + " " + endChapter;
            }
            if (this.v11n.isChapterIntro(this.start)) {
                return this.v11n.getPreferredName(startBook) + " " + startChapter + "-" + this.end.getName(base);
            }
            if (this.v11n.isBookIntro(this.start)) {
                return this.v11n.getPreferredName(startBook) + "-" + this.end.getName(base);
            }
            return this.start.getName(base) + "-" + this.end.getName(base);
        }
        if (this.isWholeBook()) {
            return this.v11n.getPreferredName(startBook);
        }
        if (startChapter != endChapter) {
            if (this.isWholeChapters()) {
                return this.v11n.getPreferredName(startBook) + " " + startChapter + "-" + endChapter;
            }
            return this.start.getName(base) + "-" + endChapter + ":" + endVerse;
        }
        if (this.isWholeChapter()) {
            return this.v11n.getPreferredName(startBook) + " " + startChapter;
        }
        if (startVerse != endVerse) {
            return this.start.getName(base) + "-" + endVerse;
        }
        return this.start.getName(base);
    }

    private Verse calcEnd() {
        if (this.verseCount == 1) {
            return this.start;
        }
        return this.v11n.add(this.start, this.verseCount - 1);
    }

    private int calcVerseCount() {
        return this.v11n.distance(this.start, this.end) + 1;
    }

    private void verifyData() {
        assert (this.verseCount == this.calcVerseCount()) : "start=" + this.start + ", end=" + this.end + ", verseCount=" + this.verseCount;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.end = this.calcEnd();
        this.shaper = new NumberShaper();
        this.verifyData();
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getCardinality() {
        return this.verseCount;
    }

    @Override
    public boolean isEmpty() {
        return this.verseCount == 0;
    }

    @Override
    public boolean contains(Key key) {
        if (key instanceof VerseRange) {
            return this.contains((VerseRange)key);
        }
        return false;
    }

    @Override
    public Iterator<Key> iterator() {
        return new VerseIterator(this);
    }

    @Override
    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
    }

    @Override
    public Key get(int index) {
        return null;
    }

    @Override
    public int indexOf(Key that) {
        return -1;
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
        VerseRange newRange = restrict.blur(this.v11n, this, by, by);
        this.start = newRange.start;
        this.end = newRange.end;
        this.verseCount = newRange.verseCount;
    }

    private static final class VerseIterator
    implements Iterator<Key> {
        private Versification v11n;
        private Verse nextVerse;
        private int count;
        private int total;

        protected VerseIterator(VerseRange range) {
            this.v11n = range.getVersification();
            this.nextVerse = range.getStart();
            this.total = range.getCardinality();
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.nextVerse != null;
        }

        @Override
        public Key next() throws NoSuchElementException {
            if (this.nextVerse == null) {
                throw new NoSuchElementException();
            }
            Verse currentVerse = this.nextVerse;
            this.nextVerse = ++this.count < this.total ? this.v11n.next(this.nextVerse) : null;
            return currentVerse;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

