/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.IOException;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexMetadata {
    public static final String INDEX_VERSION = "Installed.Index.Version";
    public static final String LATEST_INDEX_VERSION = "Latest.Index.Version";
    public static final String LUCENE_VERSION = "Lucene.Version";
    public static final float INDEX_VERSION_1_1 = 1.1f;
    public static final float INDEX_VERSION_1_2 = 1.2f;
    private static final Logger log = LoggerFactory.getLogger(IndexMetadata.class);
    private static IndexMetadata myInstance = new IndexMetadata();
    private PropertyMap props;

    private IndexMetadata() {
        try {
            this.props = ResourceUtil.getProperties(this.getClass());
        }
        catch (IOException e) {
            log.error("Property file read error", (Throwable)e);
        }
    }

    public static IndexMetadata instance() {
        return myInstance;
    }

    public float getInstalledIndexVersion() {
        String value = this.props.get(INDEX_VERSION, "1.1");
        return Float.parseFloat(value);
    }

    public float getLuceneVersion() {
        return Float.parseFloat(this.props.get(LUCENE_VERSION));
    }

    public float getLatestIndexVersion() {
        String value = this.props.get(INDEX_VERSION, "1.1");
        return Float.parseFloat(value);
    }
}

