/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.crosswire.common.util.IOUtil;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractPassageBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.versification.Versification;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwordBook
extends AbstractPassageBook {
    private AbstractBackend backend;
    private Filter filter;
    private Key global;
    private static final Logger log = LoggerFactory.getLogger(SwordBook.class);

    public SwordBook(SwordBookMetaData sbmd, AbstractBackend<?> backend) {
        super(sbmd);
        this.filter = sbmd.getFilter();
        this.backend = backend;
    }

    @Override
    public final Key getGlobalKeyList() {
        if (this.global == null) {
            try {
                this.global = this.backend.getGlobalKeyList();
                return this.global;
            }
            catch (UnsupportedOperationException ex) {
                log.debug(ex.getMessage());
            }
            catch (BookException ex) {
                log.debug(ex.getMessage());
            }
            Versification v11n = super.getVersification();
            this.global = super.createEmptyKeyList();
            Key all = PassageKeyFactory.instance().getGlobalKeyList(v11n);
            for (Key key : all) {
                if (!this.contains(key)) continue;
                this.global.addAll(key);
            }
        }
        return this.global;
    }

    @Override
    public boolean contains(Key key) {
        return this.backend != null && this.backend.contains(key);
    }

    @Override
    public String getRawText(Key key) throws BookException {
        Closeable state = null;
        try {
            state = (Closeable)this.backend.initState();
            String string = this.backend.readRawContent(state, key);
            return string;
        }
        catch (IOException e) {
            throw new BookException("Unable to obtain raw content from backend", e);
        }
        finally {
            IOUtil.close(state);
        }
    }

    @Override
    protected List<Content> getOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        if (this.backend == null) {
            return Collections.emptyList();
        }
        List<Content> result = this.backend.readToOsis(key, processor);
        assert (result != null);
        return result;
    }

    @Override
    public void addOSIS(Key key, Element div, List<Content> osisContent) {
        for (Content content : osisContent) {
            Element ele;
            if (!(content instanceof Element) || !(ele = (Element)content).getName().equals("verse")) continue;
            super.addOSIS(key, div, osisContent);
            return;
        }
        if (KeyUtil.getVerse(key).getVerse() == 0) {
            super.addOSIS(key, div, osisContent);
        } else {
            Element everse = OSISUtil.factory().createVerse();
            everse.setAttribute("osisID", key.getOsisID());
            div.addContent((Content)everse);
            super.addOSIS(key, everse, osisContent);
        }
    }

    @Override
    public void addOSIS(Key key, List<Content> contentList, List<Content> osisContent) {
        if (osisContent.size() == 0) {
            return;
        }
        if (KeyUtil.getVerse(key).getVerse() == 0) {
            Element div = OSISUtil.factory().createDiv();
            div.setAttribute("osisID", key.getOsisID());
            div.setAttribute("type", "x-gen");
            div.addContent(osisContent);
            contentList.add((Content)div);
            return;
        }
        int start = 0;
        int found = -1;
        boolean wrapped = false;
        Element preverse = null;
        for (Content content : osisContent) {
            if (content instanceof Element) {
                Element ele = (Element)content;
                String name = ele.getName();
                if ("verse".equals(name)) {
                    wrapped = true;
                    continue;
                }
                Attribute typeAttr = ele.getAttribute("type");
                Attribute subTypeAttr = ele.getAttribute("subType");
                if (subTypeAttr != null && "x-preverse".equals(subTypeAttr.getValue())) {
                    if ("div".equals(name) || "title".equals(name)) {
                        preverse = ele;
                        found = start;
                    }
                } else if (typeAttr != null && "psalm".equals(typeAttr.getValue()) && "title".equals(name)) {
                    Attribute canonicalAttr = ele.getAttribute("canonical");
                    if (canonicalAttr == null) {
                        ele.setAttribute("canonical", "true");
                    }
                    if (subTypeAttr == null) {
                        ele.setAttribute("subType", "x-preverse");
                        preverse = ele;
                        found = start;
                    }
                }
            }
            ++start;
        }
        if (wrapped) {
            super.addOSIS(key, contentList, osisContent);
            return;
        }
        Element everse = OSISUtil.factory().createVerse();
        everse.setAttribute("osisID", key.getOsisID());
        if (preverse == null) {
            everse.addContent(osisContent);
        } else {
            List<Content> sublist = osisContent.subList(found + 1, osisContent.size());
            everse.addContent(sublist);
            sublist.clear();
            super.addOSIS(key, contentList, osisContent);
        }
        contentList.add((Content)everse);
    }

    @Override
    public boolean isWritable() {
        return this.backend.isWritable();
    }

    @Override
    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        Closeable state = null;
        try {
            state = (Closeable)this.backend.initState();
            this.backend.setAliasKey(state, alias, source);
        }
        catch (IOException e) {
            throw new BookException(JSOtherMsg.lookupText("Unable to save {0}.", alias.getOsisID()));
        }
        finally {
            IOUtil.close(state);
        }
    }

    @Override
    protected Filter getFilter() {
        return this.filter;
    }
}

