/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.util.Map;
import java.util.MissingResourceException;
import org.crosswire.bibledesktop.book.install.SiteEditor;
import org.crosswire.common.config.swing.FieldMap;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.jsword.book.install.Installer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SiteEditorFactory {
    private static Map<String, Class<SiteEditor>> map = PluginUtil.getImplementorsMap(SiteEditor.class);
    private static final Logger log = LoggerFactory.getLogger(FieldMap.class);

    private SiteEditorFactory() {
    }

    public static SiteEditor createSiteEditor(Installer installer) {
        block8: {
            try {
                Class<SiteEditor> clazz = map.get(installer.getType());
                SiteEditor editor = null;
                if (clazz != null) {
                    editor = clazz.newInstance();
                    editor.setInstaller(installer);
                } else {
                    log.warn("SiteEditor type ({}) unregistered.", (Object)installer.getType());
                }
                return editor;
            }
            catch (MissingResourceException e) {
                assert (false) : e;
            }
            catch (InstantiationException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }
}

