/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.crosswire.flashcards.ComplexLessonSet;
import org.crosswire.flashcards.LessonChangeEvent;
import org.crosswire.flashcards.LessonChangeEventListener;
import org.crosswire.flashcards.LessonManager;
import org.crosswire.flashcards.LessonSet;

public class LessonSetPane
extends JPanel {
    private static final long serialVersionUID = -5348157756345036495L;
    private JList lessonSetList = new JList(new DefaultListModel());
    private boolean editable;

    public LessonSetPane() {
        this(false);
    }

    public LessonSetPane(boolean allowEdits) {
        this.editable = allowEdits;
        this.jbInit();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.lessonSetList.addListSelectionListener(listener);
    }

    private void jbInit() {
        this.lessonSetList.setSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Lesson Sets: "));
        this.add((Component)new JScrollPane(this.lessonSetList), "Center");
        JMenuBar lessonMenuBar = new JMenuBar();
        JMenu lessonSetEditMenu = new JMenu("Edit");
        JMenuItem newLessonSet = new JMenuItem("New Lesson Set");
        newLessonSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String answer = JOptionPane.showInputDialog(null, "<html>Lesson Set name:<br>(Single word, only letters)", "Create a New Lesson Set", -1);
                if (answer == null) {
                    return;
                }
                LessonSetPane.this.createLessonSet(answer);
            }
        });
        JMenuItem renameLessonSet = new JMenuItem("Rename Lesson Set");
        lessonMenuBar.add(lessonSetEditMenu);
        lessonSetEditMenu.add(newLessonSet);
        lessonSetEditMenu.add(renameLessonSet);
        if (this.editable) {
            this.add((Component)lessonMenuBar, "North");
        }
        this.loadLessonSets();
    }

    public void createLessonSet(String name) {
        ComplexLessonSet lessonSet = new ComplexLessonSet("file:" + LessonManager.instance().getHomeProjectPath() + "/" + "lessons" + '/' + name);
        DefaultListModel model = (DefaultListModel)this.lessonSetList.getModel();
        if (!model.contains(lessonSet)) {
            model.addElement(lessonSet);
            LessonManager.instance().add(lessonSet);
            this.fireLessonChanged(new LessonChangeEvent(this));
        }
        this.lessonSetList.setSelectedValue(lessonSet, true);
    }

    private void loadLessonSets() {
        LessonManager lm = LessonManager.instance();
        Vector ls = lm.getLessonSets();
        for (int i = 0; i < ls.size(); ++i) {
            LessonSet lessonSet = (LessonSet)ls.elementAt(i);
            DefaultListModel model = (DefaultListModel)this.lessonSetList.getModel();
            model.addElement(lessonSet);
        }
    }

    public synchronized void addLessonChangeEventListener(LessonChangeEventListener listener) {
        this.listenerList.add(LessonChangeEventListener.class, listener);
    }

    public synchronized void removeLessonChangeEvent(LessonChangeEventListener listener) {
        this.listenerList.remove(LessonChangeEventListener.class, listener);
    }

    public void fireLessonChanged(LessonChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$flashcards$LessonChangeEventListener == null ? LessonSetPane.class$("org.crosswire.flashcards.LessonChangeEventListener") : class$org$crosswire$flashcards$LessonChangeEventListener)) continue;
            ((LessonChangeEventListener)listeners[i + 1]).lessonChanged(e);
        }
    }
}

