/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.util.Vector;
import org.crosswire.flashcards.Lesson;

public class LessonSet {
    private String url = null;
    private String description;
    private Vector lessons = new Vector();
    private boolean modified;
    private static final long serialVersionUID = -798022075988174038L;

    public LessonSet(String url) {
        this.url = url;
        this.description = url.substring(url.lastIndexOf(47, url.length() - 2) + 1);
        if (this.description.endsWith("/")) {
            this.description = this.description.substring(0, this.description.length() - 1);
        }
        this.load();
    }

    protected void load() {
    }

    public void store() {
        for (int i = 0; i < this.lessons.size(); ++i) {
            Lesson lesson = (Lesson)this.lessons.elementAt(i);
            if (!lesson.isModified()) continue;
            lesson.store();
        }
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        for (int i = 0; i < this.lessons.size(); ++i) {
            Lesson lesson = (Lesson)this.lessons.elementAt(i);
            if (!lesson.isModified()) continue;
            return true;
        }
        return false;
    }

    public Vector getLessons() {
        return this.lessons;
    }

    public void add(Lesson lesson) {
        this.modified = true;
        this.lessons.addElement(lesson);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        if (newDescription != null && !newDescription.equals(this.description)) {
            this.modified = true;
            this.description = newDescription;
        }
    }

    public String getURL() {
        return this.url;
    }

    public int compareTo(Object obj) {
        LessonSet lesson = (LessonSet)obj;
        return this.description.compareTo(lesson.description);
    }

    public String toString() {
        return this.description;
    }

    public void augment(LessonSet other) {
        for (int i = 0; i < other.getLessons().size(); ++i) {
            Lesson l = (Lesson)other.getLessons().elementAt(i);
            Lesson exists = this.getLesson(l.getDescription());
            if (exists != null) {
                this.lessons.removeElement(exists);
            }
            this.lessons.addElement(l);
        }
    }

    public Lesson getLesson(String desc) {
        for (int i = 0; i < this.lessons.size(); ++i) {
            Lesson ls = (Lesson)this.lessons.elementAt(i);
            if (!desc.equals(ls.getDescription())) continue;
            return ls;
        }
        return null;
    }
}

