/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.crosswire.flashcards.ComplexLessonSet;
import org.crosswire.flashcards.LessonSet;

public class LessonManager {
    public static final String LESSON_ROOT = "lessons";
    private static final String DIR_PROJECT = ".flashcards";
    private static LessonManager instance = null;
    private Vector lessonSets = new Vector();
    private File homeLessonDir = null;
    private String homeProjectPath = null;

    public static LessonManager instance() {
        if (instance == null) {
            instance = new LessonManager();
        }
        return instance;
    }

    public LessonManager(String jarsPath) {
        this.loadLessonSetsFromJarDir(jarsPath);
    }

    public LessonManager() {
        try {
            this.homeProjectPath = System.getProperty("user.home") + File.separator + DIR_PROJECT;
            this.homeLessonDir = new File(this.homeProjectPath + File.separator + LESSON_ROOT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.load();
    }

    public void add(LessonSet lessonSet) {
        LessonSet exists = this.getLessonSet(lessonSet.getDescription());
        if (exists == null) {
            this.lessonSets.add(lessonSet);
        } else {
            exists.augment(lessonSet);
        }
    }

    public Vector getLessonSets() {
        return this.lessonSets;
    }

    public LessonSet getLessonSet(String description) {
        for (int i = 0; i < this.lessonSets.size(); ++i) {
            LessonSet ls = (LessonSet)this.lessonSets.elementAt(i);
            if (!description.equals(ls.getDescription())) continue;
            return ls;
        }
        return null;
    }

    public void load() {
        URL lessonsURL;
        this.loadLessonSetsFromJarDir("./");
        this.loadLessonSetsFromDir(this.homeLessonDir);
        String thisName = LessonManager.class.getName();
        String thisRes = "/" + thisName.replace('.', '/') + ".class";
        URL thisURL = LessonManager.class.getResource(thisRes);
        if (thisURL == null) {
            return;
        }
        URLConnection thisCon = null;
        try {
            thisCon = thisURL.openConnection();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (thisCon instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)thisCon;
            this.loadLessonSetsFromJarDir(new File(jarConnection.getJarFileURL().getFile()).getParent());
        }
        if ((lessonsURL = LessonManager.class.getResource("/lessons")) == null) {
            return;
        }
        URLConnection connection = null;
        try {
            connection = lessonsURL.openConnection();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)connection;
            try {
                String uri = new File(jarConnection.getJarFile().getName()).getCanonicalFile().toURL().toString();
                System.out.println("uri = " + uri);
                if (uri.startsWith("file:") && !uri.startsWith("file:/")) {
                    uri = "file:/" + uri.substring(5);
                }
                uri = uri.replace(" ", "%20");
                System.out.println("uri = " + uri);
                this.loadJarLessonSets(new File(new URI(uri)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadLessonSetsFromJarDir(String path) {
        try {
            File[] files;
            File lessonDir = new File(path);
            if (lessonDir.isDirectory() && (files = lessonDir.listFiles(new JarFileFilter())) != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.loadJarLessonSets(files[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadJarLessonSets(File jarFile) {
        JarFile jjarFile = null;
        try {
            jjarFile = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jjarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.isDirectory()) continue;
                String entryName = jarEntry.getName();
                if (!(entryName = entryName.substring(0, entryName.length() - 1)).startsWith(LESSON_ROOT) || entryName.equals(LESSON_ROOT) || entryName.endsWith("/audio")) continue;
                this.add(new ComplexLessonSet("jar:" + jarFile.getCanonicalFile().toURL().toString() + "!/" + entryName));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void loadJarLessonSets(JarFile jjarFile) {
        try {
            Enumeration<JarEntry> entries = jjarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.isDirectory()) continue;
                String entryName = jarEntry.getName();
                if (!(entryName = entryName.substring(0, entryName.length() - 1)).startsWith(LESSON_ROOT) || entryName.equals(LESSON_ROOT) || entryName.endsWith("/audio")) continue;
                System.out.println("jar:" + new File(jjarFile.getName()).getCanonicalFile().toURL().toString() + "!/" + entryName);
                this.add(new ComplexLessonSet("jar:" + new File(jjarFile.getName()).getCanonicalFile().toURL().toString() + "!/" + entryName));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void loadLessonSetsFromDir(File directory) {
        try {
            Object[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object file = files[i];
                if (!((File)file).isDirectory() || ((File)file).getName().equals("audio")) continue;
                this.add(new ComplexLessonSet(((File)files[i]).toURL().toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isModified() {
        for (int i = 0; i < this.lessonSets.size(); ++i) {
            LessonSet lessonSet = (LessonSet)this.lessonSets.elementAt(i);
            if (!lessonSet.isModified()) continue;
            return true;
        }
        return false;
    }

    public void store() {
        for (int i = 0; i < this.lessonSets.size(); ++i) {
            LessonSet lessonSet = (LessonSet)this.lessonSets.elementAt(i);
            if (!lessonSet.isModified()) continue;
            lessonSet.store();
        }
    }

    public void genImages() {
        for (int i = 0; i < this.lessonSets.size(); ++i) {
            ComplexLessonSet lessonSet = (ComplexLessonSet)this.lessonSets.elementAt(i);
            lessonSet.generateImages();
        }
    }

    public String getHomeProjectPath() {
        return this.homeProjectPath;
    }

    public static void main(String[] argv) {
        Object font = null;
        int action = 0;
        for (int i = 0; i < argv.length; ++i) {
            if (!"-genImages".equals(argv[i])) continue;
            action = 1;
        }
        switch (action) {
            case 0: {
                System.out.println("usage: LessonManager [-genImages]");
                break;
            }
            case 1: {
                LessonManager.instance().genImages();
                break;
            }
        }
    }

    static class JarFileFilter
    implements FilenameFilter {
        JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toUpperCase(Locale.ENGLISH).endsWith(".JAR");
        }
    }
}

