/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.util.Vector;
import org.crosswire.flashcards.FlashCard;

public class Lesson {
    private String url;
    private String description;
    private String font;
    private Vector flashCards = new Vector();
    private boolean modified = false;
    private static final long serialVersionUID = -4031174832238749375L;

    public Lesson() throws Exception {
        this("NewLesson.flash", "New Lesson");
    }

    public Lesson(String url) throws Exception {
        this(url, null);
    }

    public Lesson(String url, String description) throws Exception {
        this.url = url;
        this.load();
        if (description != null) {
            this.description = description;
        }
    }

    protected void load() throws Exception {
    }

    protected void store() {
    }

    public void add(FlashCard flashCard) {
        this.flashCards.addElement(flashCard);
        this.modified = true;
    }

    public void remove(FlashCard flashCard) {
        this.flashCards.removeElement(flashCard);
        this.modified = true;
    }

    public boolean contains(FlashCard flashCard) {
        return this.flashCards.contains(flashCard);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
        this.modified = true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
        this.modified = true;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String newFont) {
        this.font = newFont;
        this.modified = true;
    }

    public Vector getFlashcards() {
        return this.flashCards;
    }

    public void setModified(boolean mod) {
        this.modified = mod;
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        for (int i = 0; i < this.flashCards.size(); ++i) {
            FlashCard flashCard = (FlashCard)this.flashCards.elementAt(i);
            if (!flashCard.isModified()) continue;
            return true;
        }
        return false;
    }

    public int compareTo(Object obj) {
        Lesson lesson = (Lesson)obj;
        return this.url.compareTo(lesson.url);
    }

    public String toString() {
        return this.description;
    }
}

