/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.crosswire.common.swing.RowTable;
import org.crosswire.common.swing.RowTableModel;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.FlashCardColumns;
import org.crosswire.flashcards.FlashCardEvent;
import org.crosswire.flashcards.FlashCardEventListener;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.LessonChangeEvent;
import org.crosswire.flashcards.LessonChangeEventListener;

public class FlashCardPane
extends JPanel
implements FlashCardEventListener {
    private static final long serialVersionUID = 5685660811196521485L;
    private RowTable wordList = new RowTable(new ArrayList(), new FlashCardColumns());
    private Lesson lesson;

    public FlashCardPane() {
        this.jbInit();
    }

    private void jbInit() {
        this.wordList.setShowGrid(false);
        this.setLayout(new BorderLayout());
        this.wordList.setSelectionMode(0);
        this.add((Component)new JScrollPane(this.wordList), "Center");
    }

    public boolean contains(FlashCard flashCard) {
        return this.lesson.contains(flashCard);
    }

    public FlashCard getFlashCard(int i) {
        FlashCard flashCard = null;
        RowTableModel model = (RowTableModel)this.wordList.getModel();
        flashCard = (FlashCard)model.getRow(i);
        return flashCard;
    }

    public void add(FlashCard flashCard) {
        this.lesson.add(flashCard);
        RowTableModel model = (RowTableModel)this.wordList.getModel();
        model.addRow(flashCard);
        this.wordList.selectRow(model.getRow(flashCard));
        this.wordList.validate();
        this.wordList.repaint();
        this.fireLessonChanged(new LessonChangeEvent(this));
    }

    public void deleteSelected() {
        int row = this.wordList.getSelectedRow();
        RowTableModel model = (RowTableModel)this.wordList.getModel();
        FlashCard flashCard = (FlashCard)model.getRow(row);
        this.lesson.remove(flashCard);
        model.removeRow(flashCard);
        this.wordList.validate();
        this.wordList.repaint();
        this.fireLessonChanged(new LessonChangeEvent(this));
    }

    public void replaceSelected(FlashCard newFlashCard) {
        int row = this.wordList.getSelectedRow();
        RowTableModel model = (RowTableModel)this.wordList.getModel();
        FlashCard flashCard = (FlashCard)model.getRow(row);
        this.lesson.remove(flashCard);
        model.removeRow(flashCard);
        this.lesson.add(newFlashCard);
        model.addRow(newFlashCard);
        this.wordList.selectRow(model.getRow(newFlashCard));
        this.wordList.validate();
        this.wordList.repaint();
        this.fireLessonChanged(new LessonChangeEvent(this));
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.wordList.addListSelectionListener(listener);
    }

    public void loadFlashCards(Lesson aLesson) {
        RowTableModel model = (RowTableModel)this.wordList.getModel();
        model.clear();
        this.lesson = aLesson;
        if (this.lesson != null) {
            Vector flashcards = this.lesson.getFlashcards();
            for (int i = 0; i < flashcards.size(); ++i) {
                FlashCard flashCard = (FlashCard)flashcards.get(i);
                model.addRow(flashCard);
            }
        }
    }

    public void flashCardChanged(FlashCardEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.add(event.getFlashCard());
                break;
            }
            case 2: {
                this.deleteSelected();
                break;
            }
            case 1: {
                this.replaceSelected(event.getFlashCard());
                break;
            }
        }
    }

    public synchronized void addLessonChangeEventListener(LessonChangeEventListener listener) {
        this.listenerList.add(LessonChangeEventListener.class, listener);
    }

    public synchronized void removeLessonChangeEventListener(LessonChangeEventListener listener) {
        this.listenerList.remove(LessonChangeEventListener.class, listener);
    }

    public void fireLessonChanged(LessonChangeEvent e) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$org$crosswire$flashcards$LessonChangeEventListener == null ? FlashCardPane.class$("org.crosswire.flashcards.LessonChangeEventListener") : class$org$crosswire$flashcards$LessonChangeEventListener)) continue;
            ((LessonChangeEventListener)list[i + 1]).lessonChanged(e);
        }
    }
}

