/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.LessonManager;

public class ComplexLesson
extends Lesson {
    private static final String DIR_PROJECT = ".flashcards";
    static String homeProjectPath = "";
    static Hashtable fontURLCache = new Hashtable();
    static Font otFont = null;
    static Font ntFont = null;

    public ComplexLesson(String url) throws Exception {
        super(url);
    }

    public ComplexLesson(String url, String description) throws Exception {
        super(url, description);
    }

    public String findFont(String fontName) {
        String retVal;
        block12: {
            retVal = null;
            if (fontName == null || fontName.length() <= 0) break block12;
            String cachedURL = (String)fontURLCache.get(fontName);
            if (cachedURL != null) {
                retVal = cachedURL;
            } else {
                block14: {
                    block13: {
                        File fontFile;
                        String fontPath;
                        block11: {
                            try {
                                String url;
                                fontPath = "./" + File.separator + fontName + ".ttf";
                                fontFile = new File(fontPath);
                                if (!fontFile.exists()) break block11;
                                retVal = url = fontFile.toURL().toString();
                                fontURLCache.put(fontName, url);
                                System.out.println("found fontName in ./; URL: " + url);
                                break block12;
                            }
                            catch (AccessControlException ea) {
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            String url;
                            fontPath = homeProjectPath + File.separator + fontName + ".ttf";
                            fontFile = new File(fontPath);
                            if (!fontFile.exists()) break block13;
                            retVal = url = fontFile.toURL().toString();
                            fontURLCache.put(fontName, url);
                            System.out.println("found fontName in ~/.flashcards; URL: " + url);
                            break block12;
                        }
                        catch (AccessControlException ea) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        URL fontURL = ComplexLesson.class.getResource("/" + fontName + ".ttf");
                        if (fontURL == null) break block14;
                        URLConnection connection = null;
                        connection = fontURL.openConnection();
                        retVal = fontURL.toString();
                        fontURLCache.put(fontName, fontURL.toString());
                        System.out.println("found fontName on classpath");
                        break block12;
                    }
                    catch (AccessControlException ea) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("didn't find fontName");
            }
        }
        return retVal;
    }

    public void load() {
        try {
            int baseOffset;
            String fontURL;
            URL lessonURL = new URL(this.getURL());
            Properties lesson = new Properties();
            lesson.load(lessonURL.openConnection().getInputStream());
            int wordCount = Integer.parseInt(lesson.getProperty("wordCount"));
            this.setDescription(lesson.getProperty("lessonTitle", this.getURL().substring(this.getURL().lastIndexOf(47) + 1)));
            String fontName = lesson.getProperty("lessonFont");
            if (fontName == null || fontName.length() < 1 || fontName.equalsIgnoreCase("auto")) {
                this.setFont(null);
                if (otFont == null) {
                    fontURL = this.findFont("SILEOT");
                    otFont = this.loadFont(fontURL);
                }
                if (ntFont == null) {
                    fontURL = this.findFont("GalSILB201");
                    ntFont = this.loadFont(fontURL);
                }
            } else {
                fontURL = this.findFont(fontName);
                if (fontURL != null) {
                    this.setFont(fontURL);
                }
            }
            if ((baseOffset = this.getURL().lastIndexOf("/")) < 0) {
                baseOffset = this.getURL().lastIndexOf("\\");
            }
            String lname = this.getURL().substring(baseOffset + 1);
            lname = lname.substring(0, lname.indexOf(".flash"));
            String audioPath = this.getURL().substring(0, baseOffset) + "/audio";
            for (int i = 0; i < wordCount; ++i) {
                FlashCard f = new FlashCard(lesson.getProperty("word" + i), lesson.getProperty("answers" + i));
                String audioURLString = audioPath + "/" + lname + "_" + Integer.toString(i) + ".wav";
                URL audioURL = new URL(audioURLString);
                try {
                    audioURL.openConnection().getInputStream();
                    f.setAudioURL(audioURLString);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.add(f);
            }
            this.setModified(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Properties lesson = new Properties();
        OutputStream outStream = null;
        try {
            int i;
            lesson.setProperty("lessonTitle", this.getDescription());
            for (i = 0; i < this.getFlashcards().size(); ++i) {
                FlashCard flashCard = (FlashCard)this.getFlashcards().get(i);
                lesson.setProperty("word" + i, flashCard.getFront());
                lesson.setProperty("answers" + i, flashCard.getBack());
            }
            lesson.setProperty("wordCount", Integer.toString(i));
            URL filePath = new URL(this.getURL());
            File file = null;
            URLConnection connection = filePath.openConnection();
            file = connection instanceof JarURLConnection ? new File(LessonManager.instance().getHomeProjectPath() + File.separator + ((JarURLConnection)connection).getEntryName()) : new File(filePath.getFile());
            File dir = file.getParentFile();
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            outStream = new FileOutputStream(file);
            lesson.store(outStream, "Flash Lesson");
            this.setModified(false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font loadFont(String url) {
        Font font = null;
        if (url.length() > 2) {
            InputStream is = null;
            try {
                URLConnection connection = new URL(url).openConnection();
                is = connection.getInputStream();
                font = this.loadFont(is);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            catch (FontFormatException e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return font;
    }

    public Font loadFont(InputStream is) throws FontFormatException, IOException {
        Font font = Font.createFont(0, is);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateImages() {
        OutputStream outStream = null;
        try {
            int baseOffset = this.getURL().lastIndexOf("/");
            if (baseOffset < 0) {
                baseOffset = this.getURL().lastIndexOf("\\");
            }
            String lname = this.getURL().substring(baseOffset + 1);
            lname = lname.substring(0, lname.indexOf(".flash"));
            String imagesPath = this.getURL().substring(0, baseOffset) + "/images";
            int width = 800;
            int height = 40;
            Font font = null;
            Font ntFont = null;
            Font otFont = null;
            boolean autoFont = false;
            String fontName = this.getFont();
            if (fontName == null || fontName.length() < 1 || fontName.equalsIgnoreCase("auto")) {
                autoFont = true;
                if (ComplexLesson.otFont != null) {
                    otFont = ComplexLesson.otFont.deriveFont(1, 30.0f);
                }
                if (ComplexLesson.ntFont != null) {
                    ntFont = ComplexLesson.ntFont.deriveFont(1, 30.0f);
                }
            } else {
                Font newFont = this.loadFont(this.getFont());
                font = newFont.deriveFont(1, 30.0f);
            }
            for (int i = 0; i < this.getFlashcards().size(); ++i) {
                FlashCard f = (FlashCard)this.getFlashcards().elementAt(i);
                if (autoFont) {
                    font = null;
                    if (f.isHebrew()) {
                        font = otFont;
                    }
                    if (f.isGreek()) {
                        font = ntFont;
                    }
                }
                String imageURLString = imagesPath + "/" + lname + "_" + Integer.toString(i) + ".png";
                URL filePath = new URL(imageURLString);
                File file = null;
                URLConnection connection = filePath.openConnection();
                file = connection instanceof JarURLConnection ? new File(LessonManager.instance().getHomeProjectPath() + File.separator + ((JarURLConnection)connection).getEntryName()) : new File(filePath.getFile());
                File dir = file.getParentFile();
                if (!dir.isDirectory()) {
                    dir.mkdirs();
                }
                outStream = new FileOutputStream(file);
                BufferedImage bufferedImage = new BufferedImage(800, 40, 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, 800, 40);
                g2d.setColor(Color.black);
                g2d.setFont(font != null ? font : g2d.getFont().deriveFont(1, 29.0f));
                Rectangle2D rect = g2d.getFont().getStringBounds(f.getFront(), g2d.getFontRenderContext());
                g2d.drawString(f.getFront(), 4, 28);
                bufferedImage = bufferedImage.getSubimage(0, 0, (int)(rect.getWidth() + 8.0), 40);
                g2d.dispose();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", outStream);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            homeProjectPath = System.getProperty("user.home") + File.separator + DIR_PROJECT;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

