/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.flashcards.ComplexLessonSet;
import org.crosswire.flashcards.FlashCardPane;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.LessonPane;
import org.crosswire.flashcards.LessonSetPane;

public class SetupPane
extends JPanel {
    private static final long serialVersionUID = 1904221667403637140L;
    protected LessonPane lessonPanel = new LessonPane();
    private LessonSetPane lessonSetPanel = new LessonSetPane();
    private JCheckBox flipped = new JCheckBox("Flip the Flash Cards");
    private JCheckBox noMultipleChoice = new JCheckBox("No Multiple Choice");

    public SetupPane() {
        this.jbInit();
    }

    public boolean isFlipped() {
        return this.flipped.isSelected();
    }

    public boolean isNoMultipleChoice() {
        return this.noMultipleChoice.isSelected();
    }

    public Iterator iterator() {
        return this.lessonPanel.iterator();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select a Lesson Set, then one or more Lessons: "));
        FlashCardPane flashCardPanel = new FlashCardPane();
        this.lessonSetPanel.addListSelectionListener(new LessonSetSelectionListener(this.lessonPanel));
        this.lessonPanel.addListSelectionListener(new LessonSelectionListener(flashCardPanel));
        JSplitPane horizontalSplitPane = new JSplitPane();
        horizontalSplitPane.setResizeWeight(0.3);
        horizontalSplitPane.setDividerLocation(0.3);
        horizontalSplitPane.setRightComponent(this.lessonPanel);
        horizontalSplitPane.setLeftComponent(this.lessonSetPanel);
        this.add((Component)horizontalSplitPane, "Center");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Quiz Options: "));
        panel.add(this.flipped);
        panel.add(this.noMultipleChoice);
        this.add((Component)panel, "South");
    }

    static class LessonSelectionListener
    implements ListSelectionListener {
        private FlashCardPane flashCardPanel;

        public LessonSelectionListener(FlashCardPane flashCardPanel) {
            this.flashCardPanel = flashCardPanel;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            Object[] selections = list.getSelectedValues();
            if (selections != null && selections.length == 1) {
                this.flashCardPanel.loadFlashCards((Lesson)selections[0]);
            }
        }
    }

    static class LessonSetSelectionListener
    implements ListSelectionListener {
        private LessonPane lessonPanel;

        public LessonSetSelectionListener(LessonPane lessonPanel) {
            this.lessonPanel = lessonPanel;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            this.lessonPanel.loadLessons((ComplexLessonSet)list.getSelectedValue());
        }
    }
}

