/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.util.Enumeration;
import java.util.Hashtable;

public class FlashCard {
    private Hashtable original = new Hashtable();
    private Hashtable values = new Hashtable();
    private final String front = "front";
    private final String back = "back";
    private final String audioURL = "audioURL";
    private final String imageURL = "imageURL";

    public FlashCard() {
        this("", "");
    }

    public FlashCard(String frontValue, String backValue) {
        this.original.put("front", frontValue);
        this.original.put("back", backValue);
        this.reset();
    }

    public String getSide(boolean frontside) {
        if (frontside) {
            return this.getFront();
        }
        return this.getBack();
    }

    public String getBack() {
        return (String)this.values.get("back");
    }

    public void setBack(String newBack) {
        this.values.put("back", newBack);
    }

    public String getFront() {
        return (String)this.values.get("front");
    }

    public void setFront(String newFront) {
        this.values.put("front", newFront);
    }

    public String getAudioURL() {
        return (String)this.values.get("audioURL");
    }

    public void setAudioURL(String newAudioURL) {
        this.values.put("audioURL", newAudioURL);
    }

    public String getImageURL() {
        return (String)this.values.get("imageURL");
    }

    public void setImageURL(String newImageURL) {
        this.values.put("imageURL", newImageURL);
    }

    public boolean isGreek() {
        char firstGlyph = this.getFront().charAt(0);
        return firstGlyph >= '\u0370' && firstGlyph <= '\u03ff' || firstGlyph >= '\u1f00' && firstGlyph <= '\u1fff';
    }

    public boolean isHebrew() {
        char firstGlyph = this.getFront().charAt(0);
        return firstGlyph >= '\u0590' && firstGlyph <= '\u05ff' || firstGlyph >= '\ufb00' && firstGlyph <= '\ufb4f';
    }

    public void reset() {
        FlashCard.hashCopy(this.values, this.original);
    }

    private static void hashCopy(Hashtable dest, Hashtable src) {
        dest.clear();
        Enumeration k = src.keys();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            dest.put(key, src.get(key));
        }
    }

    public boolean isIncomplete() {
        return this.values.get("front") != null && this.values.get("back") != null;
    }

    public void setOriginal() {
        FlashCard.hashCopy(this.original, this.values);
    }

    protected boolean isModified() {
        return !this.values.equals(this.original);
    }

    public Object clone() {
        FlashCard n = new FlashCard();
        FlashCard.hashCopy(n.original, this.original);
        FlashCard.hashCopy(n.values, this.values);
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlashCard)) {
            return false;
        }
        FlashCard otherCard = (FlashCard)obj;
        return this.values.equals(otherCard.values);
    }

    public int compareTo(Object other) {
        return this.getFront().compareTo(((FlashCard)other).getFront());
    }
}

