/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.io.File;
import java.io.FilenameFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.crosswire.flashcards.ComplexLesson;
import org.crosswire.flashcards.LessonSet;

public class ComplexLessonSet
extends LessonSet {
    public ComplexLessonSet(String url) {
        super(url);
    }

    protected void load() {
        if (this.getURL() == null) {
            return;
        }
        URL lessonsURL = null;
        URLConnection connection = null;
        try {
            lessonsURL = new URL(this.getURL());
            connection = lessonsURL.openConnection();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)connection;
            this.loadJarLessonSet(jarConnection);
        } else if (lessonsURL != null) {
            this.loadDirectoryLessonSet(new File(lessonsURL.getFile()));
        }
    }

    private void loadJarLessonSet(JarURLConnection jarConnection) {
        String dirName = jarConnection.getEntryName();
        JarFile jarFile = null;
        try {
            jarFile = jarConnection.getJarFile();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String lessonPath = jarEntry.getName();
            if (!lessonPath.startsWith(dirName) || jarEntry.isDirectory() || !lessonPath.toUpperCase(Locale.ENGLISH).endsWith(".FLASH")) continue;
            try {
                this.add(new ComplexLesson("jar:" + jarConnection.getJarFileURL() + "!/" + lessonPath));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadDirectoryLessonSet(File directory) {
        Object[] files = directory.listFiles(new FlashFileFilter());
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            try {
                this.add(new ComplexLesson(((File)files[i]).getCanonicalFile().toURL().toString()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getNextLessonFilename() {
        String result = null;
        int next = this.getLessons().size();
        Object[] params = new Object[]{this.getURL(), new Integer(next)};
        MessageFormat format = new MessageFormat("{0}/lesson{1,number,00}.flash");
        result = format.format(params);
        return result;
    }

    public void generateImages() {
        for (int i = 0; i < this.getLessons().size(); ++i) {
            ComplexLesson lesson = (ComplexLesson)this.getLessons().elementAt(i);
            lesson.generateImages();
        }
    }

    static class FlashFileFilter
    implements FilenameFilter {
        FlashFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toUpperCase(Locale.ENGLISH).endsWith(".FLASH");
        }
    }
}

