/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import org.crosswire.jsword.passage.BitwisePassage;
import org.crosswire.jsword.passage.DistinctPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.RocketPassage;
import org.crosswire.jsword.versification.Versification;

public abstract class PassageType
extends Enum<PassageType> {
    public static final /* enum */ PassageType SPEED = new PassageType(){

        @Override
        public Passage createPassage(Versification v11n, String passage, Key basis) throws NoSuchVerseException {
            if (passage == null || passage.length() == 0) {
                return this.createEmptyPassage(v11n);
            }
            return new RocketPassage(v11n, passage, basis);
        }

        @Override
        public Passage createEmptyPassage(Versification v11n) {
            return new RocketPassage(v11n);
        }
    };
    public static final /* enum */ PassageType WRITE_SPEED = new PassageType(){

        @Override
        public Passage createPassage(Versification v11n, String passage, Key basis) throws NoSuchVerseException {
            if (passage == null || passage.length() == 0) {
                return this.createEmptyPassage(v11n);
            }
            return new BitwisePassage(v11n, passage, basis);
        }

        @Override
        public Passage createEmptyPassage(Versification v11n) {
            return new BitwisePassage(v11n);
        }
    };
    public static final /* enum */ PassageType SIZE = new PassageType(){
        private static final long serialVersionUID = -1959355535575121168L;

        @Override
        public Passage createPassage(Versification v11n, String passage, Key basis) throws NoSuchVerseException {
            if (passage == null || passage.length() == 0) {
                return this.createEmptyPassage(v11n);
            }
            return new DistinctPassage(v11n, passage, basis);
        }

        @Override
        public Passage createEmptyPassage(Versification v11n) {
            return new DistinctPassage(v11n);
        }
    };
    public static final /* enum */ PassageType MIX = new PassageType(){

        @Override
        public Passage createPassage(Versification v11n, String passage, Key basis) throws NoSuchVerseException {
            if (passage == null || passage.length() == 0) {
                return this.createEmptyPassage(v11n);
            }
            return new RangedPassage(v11n, passage, basis);
        }

        @Override
        public Passage createEmptyPassage(Versification v11n) {
            return new RangedPassage(v11n);
        }
    };
    public static final /* enum */ PassageType TALLY = new PassageType(){

        @Override
        public Passage createPassage(Versification v11n, String passage, Key basis) throws NoSuchVerseException {
            if (passage == null || passage.length() == 0) {
                return this.createEmptyPassage(v11n);
            }
            return new PassageTally(v11n, passage, basis);
        }

        @Override
        public Passage createEmptyPassage(Versification v11n) {
            return new PassageTally(v11n);
        }
    };
    private static final /* synthetic */ PassageType[] $VALUES;

    public static PassageType[] values() {
        return (PassageType[])$VALUES.clone();
    }

    public static PassageType valueOf(String name) {
        return Enum.valueOf(PassageType.class, name);
    }

    public abstract Passage createPassage(Versification var1, String var2, Key var3) throws NoSuchVerseException;

    public Passage createPassage(Versification v11n, String passage) throws NoSuchVerseException {
        return this.createPassage(v11n, passage, null);
    }

    public abstract Passage createEmptyPassage(Versification var1);

    public static PassageType fromString(String name) {
        for (PassageType v : PassageType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        assert (false);
        return null;
    }

    public static PassageType fromInteger(int i) {
        for (PassageType v : PassageType.values()) {
            if (v.ordinal() != i) continue;
            return v;
        }
        return SPEED;
    }

    public static int toInteger(PassageType type) {
        return type.ordinal();
    }

    static {
        $VALUES = new PassageType[]{SPEED, WRITE_SPEED, SIZE, MIX, TALLY};
    }
}

